% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.cross.cor.R
\name{summary.cross.cor}
\alias{summary.cross.cor}
\title{Summary of spatial cross correlation}
\usage{
\method{summary}{cross.cor}(object, ...)
}
\arguments{
\item{object}{Object of class cross.cor}

\item{...}{Ignored}
}
\value{
When not simulated k=0, prints functions list object containing:
\itemize{
\item I - Global autocorrelation statistic
\item SCI - - A data.frame with two columns representing the xy and yx autocorrelation
\item nsim - value of NULL to represent p values were derived from observed data (k=0)
\item p - Probability based observations above/below confidence interval
\item t.test - Probability based on t-test
}

When simulated (k>0), prints functions list object containing:
\itemize{
\item I - Global autocorrelation statistic
\item SCI - A data.frame with two columns representing the xy and yx autocorrelation
\item nsim - value representing number of simulations
\item global.p - p-value of global autocorrelation statistic
\item local.p - Probability based simulated data using successful rejection of t-test
\item range.p - Probability based on range of probabilities resulting from paired t-test
}
}
\description{
summary method for class "cross.cor"
}
