% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spell_functions.R
\docType{data}
\name{coca_list}
\alias{coca_list}
\title{COCA Word List}
\format{
A character vector with 100,000 elements:
\describe{
Each element is a word from COCA, with the first element being the most
frequent word ("the") and subsequent elements decreasing in frequency.
}
}
\source{
Corpus of Contemporary American English (COCA)
\url{https://www.english-corpora.org/coca/}
}
\usage{
coca_list
}
\description{
A character vector containing the 100,000 most frequent words from the
Corpus of Contemporary American English (COCA), sorted by frequency from
most to least frequent. This word list serves as the default reference
for spelling correction in the spell_replace function.
}
\examples{
# View the first 10 most frequent words
head(coca_list, 10)

# Check if a word is in the list
"hello" \%in\% coca_list

# Find the rank of a specific word
which(coca_list == "hello")
}
\keyword{datasets}
