% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StmtSet.R
\name{StmtSet}
\alias{StmtSet}
\title{SET statement.}
\description{
SET statement.

SET statement.
}
\details{
This class represents a SQL SET statement, used in UPDATE queries to set
field values. It can hold one or more field/value pairs.
The factory function \code{\link{make_set}()} can be used to create
a SET statement more easily.
}
\examples{
# Create a SET statement with a single field/value pair:
set_stmt <- StmtSet$new()
set_stmt$add_field(ExprField$new("price"), ExprValue$new(9.50))

# Use the created SET statement inside an UPDATE query:
query <- QueryUpdate$new(StmtUpdate$new("books"), set = set_stmt)

}
\seealso{
\code{\link{make_set}()}
}
\section{Super class}{
\code{\link[sqlq:Statement]{sqlq::Statement}} -> \code{StmtSet}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-StmtSet-new}{\code{StmtSet$new()}}
\item \href{#method-StmtSet-add_field}{\code{StmtSet$add_field()}}
\item \href{#method-StmtSet-getTokens}{\code{StmtSet$getTokens()}}
\item \href{#method-StmtSet-clone}{\code{StmtSet$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="sqlq" data-topic="Statement" data-id="toString"><a href='../../sqlq/html/Statement.html#method-Statement-toString'><code>sqlq::Statement$toString()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StmtSet-new"></a>}}
\if{latex}{\out{\hypertarget{method-StmtSet-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StmtSet$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StmtSet-add_field"></a>}}
\if{latex}{\out{\hypertarget{method-StmtSet-add_field}{}}}
\subsection{Method \code{add_field()}}{
Add a field/value pair.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StmtSet$add_field(field, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{The field, as an ExprField instance.}

\item{\code{value}}{The value to set, as an Expr instance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StmtSet-getTokens"></a>}}
\if{latex}{\out{\hypertarget{method-StmtSet-getTokens}{}}}
\subsection{Method \code{getTokens()}}{
Generates the list of tokens representing this statement.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StmtSet$getTokens()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of Token objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StmtSet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-StmtSet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StmtSet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
