% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factories.R
\name{make_create_table}
\alias{make_create_table}
\title{Create an SQL CREATE TABLE query.}
\usage{
make_create_table(tabl, fields_def)
}
\arguments{
\item{tabl}{Name of the new table}

\item{fields_def}{An list of ExprFieldDef instances.}
}
\value{
An instance of QueryCreate.
}
\description{
Create a QueryCreate instance.
}
\examples{
# To generate the CREATE query for creating a simple table for listing books:
fields_def <- list(ExprFieldDef$new('id', 'integer', primary=TRUE),
                   ExprFieldDef$new('title', 'varchar(200)', nullable=FALSE),
                   ExprFieldDef$new('author', 'varchar(80)', nullable=FALSE))
create <- make_create_table(tabl = 'books', fields_def = fields_def)

}
