testthat::context("ExprBetween class")

testthat::test_that("Initializer works fine", {
  testthat::expect_error(ExprBetween$new())
  testthat::expect_error(ExprBetween$new(ExprField$new("i")))
  testthat::expect_error(ExprBetween$new(ExprField$new("i"), ExprValue$new(1)))
  ExprBetween$new(ExprField$new("i"), ExprValue$new(1), ExprValue$new(10))
})

testthat::test_that("Conversion to string works fine", {
  x <- ExprBetween$new(ExprField$new("i"), ExprValue$new(1), ExprValue$new(10))
  testthat::expect_equal(x$toString(), "i BETWEEN 1 AND 10")
})

testthat::test_that("Factory works fine", {
  x <- make_between('i', 1, 10)
  testthat::expect_equal(x$toString(), "i BETWEEN 1 AND 10")
})
