% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HeckmanCL.R
\name{HeckmanCL}
\alias{HeckmanCL}
\title{Classic Heckman Model Fit Function}
\usage{
HeckmanCL(selection, outcome, data = sys.frame(sys.parent()), start = NULL)
}
\arguments{
\item{selection}{A formula specifying the selection equation.}

\item{outcome}{A formula specifying the primary outcome equation.}

\item{data}{A data frame containing the variables in the model.}

\item{start}{An optional numeric vector of initial parameter values. If not provided, default values are used.}
}
\value{
A list containing:
\itemize{
  \item \code{coefficients}: A named numeric vector of estimated parameters.
  \item \code{value}: The value of the (negative) log-likelihood at convergence.
  \item \code{loglik}: The maximized log-likelihood.
  \item \code{counts}: Number of gradient evaluations performed.
  \item \code{hessian}: Hessian matrix at the optimum.
  \item \code{fisher_infoHC}: The (approximate) Fisher information matrix.
  \item \code{prop_sigmaHC}: Approximate standard errors.
  \item \code{level}: Levels of the selection variable.
  \item \code{nObs}: Number of observations.
  \item \code{nParam}: Number of estimated parameters.
  \item \code{N0}: Number of unobserved (censored) observations.
  \item \code{N1}: Number of observed (uncensored) observations.
  \item \code{NXS}: Number of parameters in the selection equation.
  \item \code{NXO}: Number of parameters in the outcome equation.
  \item \code{df}: Degrees of freedom (observations minus parameters).
  \item \code{aic}: Akaike Information Criterion.
  \item \code{bic}: Bayesian Information Criterion.
  \item \code{initial.value}: Initial parameter values used in the optimization.
}
}
\description{
Fits the classical Heckman sample selection model using Maximum Likelihood Estimation (MLE).
Initial parameter estimates are obtained via the two-step method.
}
\details{
This function estimates the parameters of the classical Heckman sample selection model
via MLE, accounting for potential sample selection bias. It uses the \code{optim} function
with the BFGS method to find the parameter estimates that maximize the log-likelihood function.
The initial values for optimization are obtained using the two-step Heckman method.

The function returns a rich set of results, including:
\itemize{
  \item Estimated coefficients for the selection and outcome equations.
  \item Standard deviation of the outcome error term (\code{sigma}).
  \item Correlation between the errors of the selection and outcome equations (\code{rho}).
  \item Measures of model fit (AIC, BIC).
  \item Standard errors (approximated by the square root of the Fisher information diagonal).
}
}
\examples{
data(MEPS2001)
attach(MEPS2001)
selectEq <- dambexp ~ age + female + educ + blhisp + totchr + ins + income
outcomeEq <- lnambx ~ age + female + educ + blhisp + totchr + ins
HeckmanCL(selectEq, outcomeEq, data = MEPS2001)

}
\references{
\insertRef{heckman1979sample}{ssmodels}
}
