% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prophr.R
\name{prophr}
\alias{prophr}
\title{Calculate Event Probability in the Experimental Group Given a Hazard Ratio}
\usage{
prophr(p0, hr)
}
\arguments{
\item{p0}{Numeric scalar. Probability of an event in the control group (between 0 and 1).}

\item{hr}{Numeric scalar. Hazard ratio (must be > 0).}
}
\value{
Numeric. The probability of an event in the experimental group.
}
\description{
Computes the event probability in the experimental group based on the event
probability in the control group and a specified hazard ratio, assuming
proportional hazards.
}
\details{
This is useful for sample size calculations, for example in PASS (TM), which does
not automatically adjust the event rate for the experimental group.
}
\examples{
prophr(0.05, 0.6)

}
