% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/message2.R
\name{message2}
\alias{message2}
\title{Enhanced alternative to message()}
\usage{
message2(..., col = "cyan", font = 1, stop = FALSE)
}
\arguments{
\item{...}{Message content to be printed. Multiple arguments are pasted together.}

\item{col}{text color. Default is "cyan".}

\item{font}{Integer. 1 for plain text (default), 2 for bold text.}

\item{stop}{Logical. If TRUE, stops execution (like \code{stop()}) but without printing "Error:".}
}
\value{
No return value, called for side effects. Prints a colored message 
  to the console. If \code{stop = TRUE}, execution is halted after printing 
  the message.
}
\description{
Add options to set color and to end execution of code (to be used as error message)
}
\details{
This function prints colored messages to the console. If ANSI color codes are supported
by the terminal, the message will be colored. Otherwise, it will be printed as plain text.
If \code{stop = TRUE}, execution will be halted after printing the message.
}
\examples{
message2("This is a plain cyan message", col = "cyan", font = 1)
message2("This is a bold cyan message", col = "cyan", font = 2)
message2("This is a bold red message", col = "red", font = 2)
\donttest{
cat("this will be shown")
try(message2("This stops execution", stop = TRUE), silent = TRUE)
cat("this will be shown after the try")
}

}
