% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survmspline.R
\name{Survmspline}
\alias{Survmspline}
\alias{dsurvmspline}
\alias{psurvmspline}
\alias{qsurvmspline}
\alias{rsurvmspline}
\alias{hsurvmspline}
\alias{Hsurvmspline}
\alias{mean_survmspline}
\alias{rmst_survmspline}
\title{M-spline survival distribution}
\usage{
psurvmspline(
  q,
  alpha,
  coefs,
  knots,
  degree = 3,
  lower.tail = TRUE,
  log.p = FALSE,
  pcure = 0,
  offsetH = 0,
  backhaz = NULL,
  bsmooth = TRUE
)

Hsurvmspline(
  x,
  alpha,
  coefs,
  knots,
  degree = 3,
  log = FALSE,
  pcure = 0,
  offsetH = 0,
  backhaz = NULL,
  bsmooth = TRUE
)

hsurvmspline(
  x,
  alpha,
  coefs,
  knots,
  degree = 3,
  log = FALSE,
  pcure = 0,
  offseth = 0,
  backhaz = NULL,
  bsmooth = TRUE
)

dsurvmspline(
  x,
  alpha,
  coefs,
  knots,
  degree = 3,
  log = FALSE,
  pcure = 0,
  offseth = 0,
  offsetH = 0,
  backhaz = NULL,
  bsmooth = TRUE
)

qsurvmspline(
  p,
  alpha,
  coefs,
  knots,
  degree = 3,
  lower.tail = TRUE,
  log.p = FALSE,
  pcure = 0,
  offsetH = 0,
  backhaz = NULL,
  bsmooth = TRUE
)

rsurvmspline(
  n,
  alpha,
  coefs,
  knots,
  degree = 3,
  pcure = 0,
  offsetH = 0,
  backhaz = NULL,
  bsmooth = TRUE
)

rmst_survmspline(
  t,
  alpha,
  coefs,
  knots,
  degree = 3,
  pcure = 0,
  offsetH = 0,
  backhaz = NULL,
  bsmooth = TRUE,
  disc_rate = 0,
  method = "gl",
  gl_nodes = 100
)

mean_survmspline(
  alpha,
  coefs,
  knots,
  degree = 3,
  pcure = 0,
  offsetH = 0,
  backhaz = NULL,
  bsmooth = TRUE,
  disc_rate = 0
)
}
\arguments{
\item{alpha}{Log hazard scale parameter.}

\item{coefs}{Spline basis coefficients. These should sum to 1,
otherwise they are normalised internally to sum to 1.  Supplied
either as a vector with one element per basis term, or a matrix
with one column per basis term, and rows for alternative values
of the coefficients (in vectorised usage of this function).  If
an array is supplied, it is collapsed into a matrix with number
of columns equal to the final dimension of the array.}

\item{knots}{Locations of knots on the axis of time, supplied in
increasing order.  These include the two boundary knots.

In vectorised usage of these functions, the knots and degree must be
the same for all alternative times and parameter values.}

\item{degree}{Spline polynomial degree.  Can only be changed from
the default of 3 if \code{bsmooth} is \code{FALSE}.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are \eqn{P(X
\le x)}{P(X <= x)}, otherwise, \eqn{P(X > x)}{P(X > x)}.}

\item{pcure}{Probability of "cure", which defaults to zero.  If this is non-zero, this defines a "mixture cure" version of the M-spline model.}

\item{offsetH}{Constant to be added to the cumulative hazard.}

\item{backhaz}{A data frame that defines the background hazard as a piecewise-constant function of time.
This should have two columns, named \code{"time"} and
\code{"hazard"}. Each row gives the "background" hazard between the
specified time and the next time. The first element of
\code{"time"} should be 0, and the final row specifies the hazard at all
times greater than the last element of \code{"time"}.}

\item{bsmooth}{If \code{TRUE} then the function is constrained to
also have zero derivative and second derivative at the boundary.}

\item{x, q, t}{Vector of times.}

\item{log, log.p}{Return log density or probability.}

\item{offseth}{Constant to be added to the hazard, e.g. representing a "background" risk of death from causes other than the cause of interest.}

\item{p}{Vector of probabilities.}

\item{n}{Number of random numbers to simulate.}

\item{disc_rate}{Discounting rate used to calculate the discounted mean
or restricted mean survival time, using an exponential discounting function.}

\item{method}{Method of numerical integration to obtain the
restricted mean survival time from the survival function.

The default is \code{method="gl"}, a Gauss-Legendre method with 100
nodes between zero and the maximum of \code{t}.

\code{method="adaptive"} uses the base R \code{integrate} function, which is
much slower, but potentially more robust for badly-behaved
survival functions.}

\item{gl_nodes}{Number of nodes for the Gauss-Legendre method.}
}
\value{
\code{dsurvmspline} gives the density, \code{psurvmspline} gives the
distribution function, \code{hsurvmspline} gives the hazard and
\code{Hsurvmspline} gives the cumulative hazard.

\code{qsurvmspline} gives the quantile function, which is computed by
numerical inversion.

\code{rsurvmspline} generates random survival times by using
\code{qsurvmspline} on a sample of uniform random numbers.
}
\description{
Probability density, distribution, quantile, random generation,
hazard, cumulative hazard, mean and restricted mean functions for
the M-spline time-to-event model.  This can optionally be combined
with a cure probability, and / or with a known background hazard
trajectory that is a piecewise-constant function of time.
}
\details{
These are the same as the M-splines used to model survival data in \code{rstanarm}, except that an
additional assumption is made that the hazard is constant beyond the boundary knots at its
value at the boundary.   This gives a continuous but non-smooth function.

The "cure" model can be interpreted in two different ways.  These result in identical probability distribution functions for the event time, hence they are indistinguishable from data:

(a) a model where everyone follows the same hazard trajectory that is decreasing through time, with a higher rate of decrease for higher \code{pcure}.

(b) a model where a person either has a constant zero hazard at all times, or a hazard that follows a parametric model (M-spline in this case).  The probability that a person has a zero hazard is \code{pcure}.
This is the "mixture model" interpretation.

In the "background hazard" model, the overall hazard is defined as a sum of the background hazard and
a cause-specific hazard.   The cause-specific hazard
is modelled with the M-spline model, and the background hazard is assumed
to be a known piecewise-constant function defined by \code{backhaz}.

If both \code{backhaz} and \code{pcure} are supplied, then the cure probablity applies only to the cause-specific hazard.
That is, the cause-specific hazard decreases to zero, and the overall hazard converges towards
the background hazard, as time increases.
}
\references{
Ramsay, J. O. (1988). Monotone regression splines in action. Statistical Science, 3(4): 425-441.

Brilleman, S. L., Elci, E. M., Novik, J. B., & Wolfe, R. (2020). Bayesian survival analysis using the rstanarm R package. arXiv preprint arXiv:2002.09633.

Wang, W., Yan, J. (2021). Shape-restricted regression splines with R package splines2. Journal of Data Science, \emph{19}(3), 498-517.
}
\author{
Christopher Jackson \href{mailto:chris.jackson@mrc-bsu.cam.ac.uk}{chris.jackson@mrc-bsu.cam.ac.uk}
}
\keyword{distribution}
