% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs.R
\name{irmst}
\alias{irmst}
\title{Incremental restricted mean survival time}
\usage{
irmst(
  x,
  t,
  newdata = NULL,
  newdata0 = NULL,
  wane_period = NULL,
  wane_nt = 10,
  niter = NULL,
  summ_fns = NULL,
  sample = FALSE,
  disc_rate = 0,
  method = "gl",
  gl_nodes = 100
)
}
\arguments{
\item{x}{A fitted model object as returned by \code{\link{survextrap}}}

\item{t}{Vector of times.  The restricted mean survival time up to each one of these times
will be computed.}

\item{newdata}{A data frame with two rows.  The result will be the
restricted mean for the covariates in the second row, minus the
restricted mean for the covariates in the first row.  If \code{newdata} is
omitted for models where the only covariate is a factor with two
levels, then this is taken from these levels.  Otherwise \code{newdata}
must be supplied explicitly.}

\item{newdata0}{Data frame of covariate values defining the "untreated" group
for use in treatment waning models. See \code{\link{Survmspline_wane}}.}

\item{wane_period}{Vector of two numbers, defining the time period over which
the hazard is interpolated between the hazard of the "treated" group (taken from \code{newdata})
and the hazard of the "untreated" group (taken from \code{newdata0}).  Optional - if
this is not supplied, then no waning is assumed.}

\item{wane_nt}{Number of intervals defining the piecewise constant approximation
to the hazard during the waning period.}

\item{niter}{Number of MCMC iterations to use to compute credible
intervals.  Set to a low value to make this function quicker, at the cost of
some approximation error (which may not be important for plotting or model
development).}

\item{summ_fns}{A list of functions to use to summarise the posterior sample.
This is passed to \code{\link[posterior:summarise_draws]{posterior::summarise_draws}}.
By default this is \code{list(median=median, ~quantile(.x, probs=c(0.025, 0.975)))}.
If the list is named, then the names will be used for the columns of the
output.}

\item{sample}{If \code{TRUE} then an MCMC sample is returned from the posterior
of the output, rather than summary statistics.}

\item{disc_rate}{Discounting rate used to calculate the discounted mean
or restricted mean survival time, using an exponential discounting function.}

\item{method}{Method of numerical integration to obtain the
restricted mean survival time from the survival function.

The default is \code{method="gl"}, a Gauss-Legendre method with 100
nodes between zero and the maximum of \code{t}.

\code{method="adaptive"} uses the base R \code{integrate} function, which is
much slower, but potentially more robust for badly-behaved
survival functions.}

\item{gl_nodes}{Number of nodes for the Gauss-Legendre method.}
}
\value{
A data frame (tibble) with each row containing posterior summary statistics
for a particular time and covariate value.

Or if \code{sample=TRUE}, an array with dimensions
\code{length(t)}, \code{niter}, \code{nrow(newdata)}, giving the
incremental RMST evaluated at different times, MCMC iterations and covariate
values respectively.
}
\description{
Compute the difference in the restricted mean survival times
between two covariate values (e.g. treatment groups).
}
\details{
The posterior distribution is obtained by calling
\code{\link{rmst}} for each group, obtaining each posterior sample
from the \code{"sample"} attribute, and taking the difference to
get a posterior sample for the difference.
}
