% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_imputation.R
\name{validate_imputation}
\alias{validate_imputation}
\title{Validate Laboratory Non-Detect Imputation Results}
\usage{
validate_imputation(
  dt_imputed,
  value_col = "value",
  cens_col = "censored",
  verbose = TRUE
)
}
\arguments{
\item{dt_imputed}{A data.table returned from \code{\link{impute_nondetect}}}

\item{value_col}{Character string specifying the column name containing original values}

\item{cens_col}{Character string specifying the column name containing censoring indicators}

\item{verbose}{Logical indicating whether to print validation results to console (default: TRUE)}
}
\value{
Invisibly returns the input data.table. When verbose = TRUE, prints validation
  results to console including:
\itemize{
  \item Whether all imputed values are below their detection limits
  \item Number of duplicate imputed values (if any)
  \item Summary statistics by detection limit level
  \item Model fit information
}
}
\description{
This function validates the quality of non-detect value imputation by checking that
imputed values are below their respective limits of quantification and providing
comprehensive summary statistics and model diagnostics.
}
\details{
The function checks:
\itemize{
  \item All imputed values are strictly below their respective limits of quantification
  \item Uniqueness of imputed values
  \item Summary statistics by limits of quantification level
  \item Model fit information including parameter and unit details
  \item Dataset characteristics (sample size, censoring percentage)
}
}
\examples{
data(multi_censored_data)
result <- impute_nondetect(multi_censored_data, verbose = FALSE)
validate_imputation(result)

# Silent validation for batch processing
validate_imputation(result, verbose = FALSE)

}
