% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svine_methods.R
\name{svine_pseudo_residuals}
\alias{svine_pseudo_residuals}
\title{Pseudo-residuals of S-vine models}
\usage{
svine_pseudo_residuals(x, model, cores = 1)
}
\arguments{
\item{x}{the data.}

\item{model}{model inheriting from class \link{svine_dist}.}

\item{cores}{number of cores to use; if larger than one, computations are
done in parallel on \code{cores} batches .}
}
\value{
Returns a multivariate time series of pseudo-residuals
}
\description{
Pseudo-residuals are defined as the Rosenblatt transform of the data,
conditional on the past. Under a correctly specified model, they are
approximately \emph{iid} uniform on \eqn{[0, 1]^d}.
}
\examples{
# load data set
data(returns)  

# convert to pseudo observations with empirical cdf for marginal distributions
u <- pseudo_obs(returns[1:100, 1:3]) 

# fit parametric S-vine copula model with Markov order 1
fit <- svinecop(u, p = 1, family_set = "parametric")

# compute pseudo-residuals
# (should be independent uniform across variables and time)
v <- svinecop_pseudo_residuals(u, fit)
pairs(cbind(v[-1, ], v[-nrow(v), ]))

}
