% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw_tidy.R
\name{sw_tidy}
\alias{sw_tidy}
\title{Tidy the result of a time-series model into a summary tibble}
\usage{
sw_tidy(x, ...)
}
\arguments{
\item{x}{An object to be converted into a tibble ("tidy" data.frame)}

\item{...}{extra arguments}
}
\value{
a tibble
}
\description{
Tidy the result of a time-series model into a summary tibble
}
\details{
\code{sw_tidy()} is a wrapper for \code{\link[broom:reexports]{broom::tidy()}}. The main benefit of \code{sw_tidy()}
is that it has methods for various time-series model classes such as
\code{HoltWinters}, \code{ets}, \code{Arima}, etc.
\code{sw_tidy()} methods always returns a "tidy" tibble with model coefficient / parameters.

For non-time series, \code{sw_tidy()} defaults to \code{\link[broom:reexports]{broom::tidy()}}.
The only difference is that the return is a tibble.
The output of \code{sw_tidy()} is always a tibble with disposable row names. It is
therefore suited for further manipulation by packages like dplyr and
ggplot2.
}
\examples{
library(dplyr)
library(forecast)

WWWusage \%>\%
    auto.arima() \%>\%
    sw_tidy(conf.int = TRUE)

}
\seealso{
\code{\link[broom:reexports]{broom::tidy()}}
}
