% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_cues.R
\name{extract_cues}
\alias{extract_cues}
\title{Extract multiple sub-samples of data}
\usage{
extract_cues(x, sampling_rate, cues, len)
}
\arguments{
\item{x}{is a vector or matrix of measurements. If x is a matrix, each column is treated as a separate measurement vector.}

\item{sampling_rate}{is the sampling rate in Hz of the data in x.}

\item{cues}{defines the start time in seconds of the intervals to be extracted from x.}

\item{len}{is the length of the interval to extract in seconds. This should be a scalar.}
}
\value{
A list with 2 elements:
\itemize{
\item{\strong{X: }} A matrix containing sub-samples of x. If x is a vector, X has as many columns as there are cues, i.e., each cue generates a column of X. If x is a pxm matrix, X will be a qxmxn matrix where n is the size of cues and q is the length of the interval requested, i.e., round(sampling_rate*len) samples.
\item{\strong{cues: }} The list of cues actually used. cues that require data outside of x are rejected.
}
}
\description{
This function is used to extract multiple sub-samples of data from a vector or matrix.
}
\note{
Output sampling rate is the same as the input sampling rate.
}
\examples{
BW <- beaked_whale # beaked_whale must be in your working directory
list <- extract_cues(x = BW$A$data, sampling_rate = BW$A$sampling_rate, cues = c(6, 40), len = 11)
}
