% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile-typing.R
\name{is.categorical}
\alias{is.categorical}
\title{Determine if a vector is categorical or not}
\usage{
is.categorical(x, threshold = NA)
}
\arguments{
\item{x}{Vector to determine type of}

\item{threshold}{The upper threshold of unique values for which a vector is considered categorical.}
}
\value{
A Boolean: TRUE / FALSE
}
\description{
Determine if a vector is categorical or not
}
\examples{

is.categorical(c(1,2,3))
is.categorical(c(rep(1,20), rep(2, 20), rep(3, 20)), threshold=5)
is.categorical(c("A","B","B"))
is.categorical(factor(c("A","B","C")))
is.categorical(factor(c("A","B","B","A")))
is.categorical(factor(c(TRUE, FALSE, TRUE, FALSE)))

}
