% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db.R
\name{is_db_connect}
\alias{is_db_connect}
\title{Test Database Connection}
\usage{
is_db_connect()
}
\value{
Logical. \code{TRUE} if the database can be connected successfully,
  \code{FALSE} otherwise.
}
\description{
Checks whether a connection to the PostgreSQL database can be established
with the current configuration.
}
\details{
This function attempts to create a database connection using the credentials
in environment variables or \code{taskqueue_options()}. It returns FALSE if
the connection fails for any reason (wrong credentials, network issues,
PostgreSQL not running, etc.).

Useful for testing database configuration before running workers or adding tasks.
}
\examples{
\dontrun{
# Not run:
# Test connection
if (is_db_connect()) {
  message("Database is accessible")
  db_init()
} else {
  stop("Cannot connect to database. Check .Renviron settings.")
}
}
}
\seealso{
\code{\link{db_connect}}, \code{\link{taskqueue_options}}
}
