% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast_scientificname.R
\name{cast_scientificname}
\alias{cast_scientificname}
\title{Cast scientific name using taxonomic fields}
\usage{
cast_scientificname(
  dat = NULL,
  sciname = "scientificname",
  genus = "",
  subgenus = "",
  species = "",
  subspecies = "",
  author = "",
  verbose = FALSE
)
}
\arguments{
\item{dat}{data frame containing taxonomic data}

\item{sciname}{column name for scientific names, Default: 'scientificname'}

\item{genus}{column name for genus, Default: 'genus'}

\item{subgenus}{column name for subgenus, Default: ''}

\item{species}{column name for species, Default: 'species'}

\item{subspecies}{column name for subspecies, Default: 'subspecies'}

\item{author}{column name for author, Default: 'author'}

\item{verbose}{verbose output, Default: FALSE}
}
\value{
data frame with additional columns for taxonomic fields
}
\description{
Combine scientific names using Genus, Species, Subspecies,
 Author etc.
}
\details{
Helpful function to break down Scientific names into Genus, Subgenus,
species, Subspecies, Author so that the names can be constructed into canonical
 names for matching
}
\examples{
\donttest{
mylist <- data.frame("id" = c(11,12,13,14,15,16,17,18,19),
                     "genus" = c("Hypochlorosis","Hypochlorosis","Hypochlorosis",
                                 "Myrina","Hypochlorosis","Hypochlorosis",
                                 "Hypochlorosis","Seuku","Sithon"),
                     "subgenus" = c("","","","","","","(Pseudonotis)","",""),
                     "species" = c("ancharia","ancharia","ancharia",
                                   "lorquinii","ancharia","ancharia",
                                   "metilia","emlongi","lorquinii"),
                     "subspecies" = c("","ancharia","humboldti",
                                      "","tenebrosa"," tenebrosa",
                                      "","",""),
                     "author" = c("(Hewitson, 1869)","(Hewitson, 1869)","Druce, 1894",
                                  "C. & R. Felder, 1865","Rothschild, 1915",
                                  "Rothschild, 1915","Fruhstorfer, 1908",
                                  "(Domning et al., 1986)",""),
                     stringsAsFactors = FALSE)

cast_scientificname(mylist,genus = "genus", subgenus = "subgenus",
                    species = "species", subspecies = "subspecies",
                    author = "author")
}
}
\seealso{
Other Name functions: 
\code{\link{build_gen_syn}()},
\code{\link{cast_canonical}()},
\code{\link{check_scientific}()},
\code{\link{expand_name}()},
\code{\link{get_accepted_names}()},
\code{\link{guess_taxo_rank}()},
\code{\link{list_higher_taxo}()},
\code{\link{melt_canonical}()},
\code{\link{melt_scientificname}()},
\code{\link{resolve_names}()},
\code{\link{taxo_fuzzy_match}()}
}
\concept{Name functions}
