testthat::test_that("ui_previewer_card_actions returns a shiny tag or tagList", {
  checkmate::expect_multi_class(
    ui_previewer_card_actions("an_id"),
    c("shiny.tag", "shiny.tag.list")
  )
})

testthat::test_that("srv_previewer_card_actions removes a teal card", {
  reporter <- Reporter$new()
  reporter$append_cards(teal_card("## Header", "A paragraph."))
  shiny::testServer(
    srv_previewer_card_actions,
    args = list(
      id = "id",
      card_r = reactive(reporter$get_cards()[[1]]),
      card_id = names(reporter$get_cards()),
      reporter = reporter
    ),
    {
      session$setInputs(remove_action = 1)
      testthat::expect_equal(length(reporter$get_cards()), 0)
    }
  )
})

testthat::test_that("srv_previewer_card_actions saves the new card without contents but changed title", {
  reporter <- Reporter$new()
  reporter$append_cards(teal_card("## Header", "A paragraph."))

  new_card <- teal_card("## A new Header", "A new paragraph.")
  names(new_card) <- c("element_1", "element_2")
  shiny::testServer(
    srv_previewer_card_actions,
    args = list(
      id = "id",
      card_r = reactive(reporter$get_cards()[[1]]),
      card_id = names(reporter$get_cards()),
      reporter = reporter
    ),
    {
      new_card_rv(new_card)
      session$setInputs(
        "editor-blocks-element_1-content" = sprintf("%s (modified)", new_card[[1]]),
        "editor-blocks-element_2-content" = new_card[[2]]
      ) # Mocks the inputs generated by the UI
      session$flushReact()
      session$setInputs(edit_save = 1)
      testthat::expect_equal(
        reporter$get_cards()[[1]],
        list("## A new Header (modified)", "A new paragraph."),
        ignore_attr = c("names", "class", "metadata")
      )
    }
  )
})

testthat::test_that("srv_previewer_card_actions triggers a shiny modal", {
  reporter <- Reporter$new()
  reporter$append_cards(teal_card("## Header", "A paragraph."))


  new_card <- teal_card("## A new Header", "A new paragraph.")
  names(new_card) <- c("element_1", "element_2")

  testthat::expect_warning(
    testthat::with_mocked_bindings(
      showModal = function(...) warning("Modal was shown"),
      .package = "shiny",
      code = shiny::testServer(
        srv_previewer_card_actions,
        args = list(
          id = "id",
          card_r = reactive(reporter$get_cards()[[1]]),
          card_id = names(reporter$get_cards()),
          reporter = reporter
        ),
        {
          session$flushReact()
          session$setInputs(edit_action = 1)
        }
      )
    ),
    "Modal was shown"
  )
})
