% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_num_patients.R
\name{summarize_num_patients}
\alias{summarize_num_patients}
\alias{analyze_num_patients}
\alias{s_num_patients}
\alias{s_num_patients_content}
\alias{a_num_patients}
\title{Count number of patients}
\usage{
analyze_num_patients(
  lyt,
  vars,
  required = NULL,
  count_by = NULL,
  unique_count_suffix = TRUE,
  na_str = default_na_str(),
  nested = TRUE,
  show_labels = c("default", "visible", "hidden"),
  riskdiff = FALSE,
  ...,
  .stats = c("unique", "nonunique", "unique_count"),
  .stat_names = NULL,
  .formats = NULL,
  .labels = list(unique = "Number of patients with at least one event", nonunique =
    "Number of events"),
  .indent_mods = NULL
)

summarize_num_patients(
  lyt,
  var,
  required = NULL,
  count_by = NULL,
  unique_count_suffix = TRUE,
  na_str = default_na_str(),
  riskdiff = FALSE,
  ...,
  .stats = c("unique", "nonunique", "unique_count"),
  .stat_names = NULL,
  .formats = NULL,
  .labels = list(unique = "Number of patients with at least one event", nonunique =
    "Number of events"),
  .indent_mods = 0L
)

s_num_patients(
  x,
  labelstr,
  .N_col,
  ...,
  count_by = NULL,
  unique_count_suffix = TRUE
)

s_num_patients_content(
  df,
  labelstr = "",
  .N_col,
  .var,
  ...,
  required = NULL,
  count_by = NULL,
  unique_count_suffix = TRUE
)

a_num_patients(
  df,
  labelstr = "",
  ...,
  .stats = NULL,
  .stat_names = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout that analyses will be added to.}

\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{required}{(\code{character} or \code{NULL})\cr name of a variable that is required to be non-missing.}

\item{count_by}{(\code{character} or \code{NULL})\cr name of a variable to be combined with \code{vars} when counting
\code{nonunique} records.}

\item{unique_count_suffix}{(\code{flag})\cr whether the \code{"(n)"} suffix should be added to \code{unique_count} labels.
Defaults to \code{TRUE}.}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{nested}{(\code{flag})\cr whether this layout instruction should be applied within the existing layout structure _if
possible (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split.
underneath analyses, which is not allowed.}

\item{show_labels}{(\code{string})\cr label visibility: one of "default", "visible" and "hidden".}

\item{riskdiff}{(\code{flag})\cr whether a risk difference column is present. When set to \code{TRUE}, \code{\link[=add_riskdiff]{add_riskdiff()}} must be
used as \code{split_fun} in the prior column split of the table layout, specifying which columns should be compared.
See \code{\link[=stat_propdiff_ci]{stat_propdiff_ci()}} for details on risk difference calculation.}

\item{...}{additional arguments for the lower level functions.}

\item{.stats}{(\code{character})\cr statistics to select for the table.

Options are: \verb{'unique', 'nonunique', 'unique_count'}}

\item{.stat_names}{(\code{character})\cr names of the statistics that are passed directly to name single statistics
(\code{.stats}). This option is visible when producing \code{\link[rtables:data.frame_export]{rtables::as_result_df()}} with \code{make_ard = TRUE}.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{x}{(\code{character} or \code{factor})\cr vector of patient IDs.}

\item{labelstr}{(\code{string})\cr label of the level of the parent split currently being summarized
(must be present as second argument in Content Row Functions). See \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}
for more information.}

\item{.N_col}{(\code{integer(1)})\cr column-wise N (column count) for the full column being analyzed that is typically
passed by \code{rtables}.}

\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var, var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}
}
\value{
\itemize{
\item \code{analyze_num_patients()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_num_patients_content()} to the table layout.
}

\itemize{
\item \code{summarize_num_patients()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_num_patients_content()} to the table layout.
}

\itemize{
\item \code{s_num_patients()} returns a named \code{list} of 3 statistics:
\itemize{
\item \code{unique}: Vector of counts and percentages.
\item \code{nonunique}: Vector of counts.
\item \code{unique_count}: Counts.
}
}

\itemize{
\item \code{s_num_patients_content()} returns the same values as \code{s_num_patients()}.
}

\itemize{
\item \code{a_num_patients()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The analyze function \code{\link[=analyze_num_patients]{analyze_num_patients()}} creates a layout element to count total numbers of unique or
non-unique patients. The primary analysis variable \code{vars} is used to uniquely identify patients.

The \code{count_by} variable can be used to identify non-unique patients such that the number of patients with a unique
combination of values in \code{vars} and \code{count_by} will be returned instead as the \code{nonunique} statistic. The \code{required}
variable can be used to specify a variable required to be non-missing for the record to be included in the counts.

The summarize function \code{\link[=summarize_num_patients]{summarize_num_patients()}} performs the same function as \code{\link[=analyze_num_patients]{analyze_num_patients()}} except it
creates content rows, not data rows, to summarize the current table row/column context and operates on the level of
the latest row split or the root of the table if no row splits have occurred.
}
\details{
In general, functions that starts with \verb{analyze*} are expected to
work like \code{\link[rtables:analyze]{rtables::analyze()}}, while functions that starts with \verb{summarize*}
are based upon \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}. The latter provides a
value for each dividing split in the row and column space, but, being it
bound to the fundamental splits, it is repeated by design in every page
when pagination is involved.
}
\section{Functions}{
\itemize{
\item \code{analyze_num_patients()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

\item \code{summarize_num_patients()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}.

\item \code{s_num_patients()}: Statistics function which counts the number of
unique patients, the corresponding percentage taken with respect to the
total number of patients, and the number of non-unique patients.

\item \code{s_num_patients_content()}: Statistics function which counts the number of unique patients
in a column (variable), the corresponding percentage taken with respect to the total number of
patients, and the number of non-unique patients in the column.

\item \code{a_num_patients()}: Formatted analysis function which is used as \code{afun}
in \code{analyze_num_patients()} and as \code{cfun} in \code{summarize_num_patients()}.

}}
\note{
As opposed to \code{\link[=summarize_num_patients]{summarize_num_patients()}}, this function does not repeat the produced rows.
}
\examples{
df <- data.frame(
  USUBJID = as.character(c(1, 2, 1, 4, NA, 6, 6, 8, 9)),
  ARM = c("A", "A", "A", "A", "A", "B", "B", "B", "B"),
  AGE = c(10, 15, 10, 17, 8, 11, 11, 19, 17),
  SEX = c("M", "M", "M", "F", "F", "F", "M", "F", "M")
)

# analyze_num_patients
tbl <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  add_colcounts() \%>\%
  analyze_num_patients("USUBJID", .stats = c("unique")) \%>\%
  build_table(df)

tbl

# summarize_num_patients
tbl <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("SEX") \%>\%
  summarize_num_patients("USUBJID", .stats = "unique_count") \%>\%
  build_table(df)

tbl

# Use the statistics function to count number of unique and nonunique patients.
s_num_patients(x = as.character(c(1, 1, 1, 2, 4, NA)), labelstr = "", .N_col = 6L)
s_num_patients(
  x = as.character(c(1, 1, 1, 2, 4, NA)),
  labelstr = "",
  .N_col = 6L,
  count_by = c(1, 1, 2, 1, 1, 1)
)

# Count number of unique and non-unique patients.

df <- data.frame(
  USUBJID = as.character(c(1, 2, 1, 4, NA)),
  EVENT = as.character(c(10, 15, 10, 17, 8))
)
s_num_patients_content(df, .N_col = 5, .var = "USUBJID")

df_by_event <- data.frame(
  USUBJID = as.character(c(1, 2, 1, 4, NA)),
  EVENT = c(10, 15, 10, 17, 8)
)
s_num_patients_content(df_by_event, .N_col = 5, .var = "USUBJID", count_by = "EVENT")

}
\keyword{internal}
