% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TopFunction.R
\name{train_full_model}
\alias{train_full_model}
\title{Train a full model pipeline including text preprocessing, TF-IDF vectorization,
random forest tuning, and training.}
\arguments{
\item{custom_slang}{A named list for custom slang replacements (optional).}

\item{max_features}{Maximum number of features for TF-IDF vectorizer (default 10000).}

\item{min_df}{Minimum document frequency for TF-IDF (default 2).}

\item{max_df}{Maximum document frequency for TF-IDF (default 0.8).}

\item{mtry_grid}{Grid of values for `mtry` parameter to tune in random forest (default: c(5, 10, 20)).}

\item{ntree_grid}{Grid of values for `ntree` parameter to tune in random forest (default: c(100, 200, 300)).}

\item{stopwords_file}{Path to the stopwords RDS file (default: "final_stopwords.rds").}

\item{vectorizer_file}{Path to save the trained vectorizer (default: "trained_vectorizer.rds").}

\item{tfidf_model_file}{Path to save the trained TF-IDF model (default: "trained_tfidf_model.rds").}

\item{rf_model_file}{Path to save the trained random forest model (default: "trained_rf_ranger_model.rds").}

\item{train_df_cache_path}{Path to cache the training data frame (default: "train_df_cached.rds").}
}
\value{
A list containing the trained TF-IDF model, vectorizer, random forest model, and test accuracy.
}
\description{
Train a full model pipeline including text preprocessing, TF-IDF vectorization,
random forest tuning, and training.
}
