% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnn_estimators.R
\name{dnn_estimators}
\alias{dnn_estimators}
\alias{dnn_regressor}
\alias{dnn_classifier}
\title{Deep Neural Networks}
\usage{
dnn_regressor(
  hidden_units,
  feature_columns,
  model_dir = NULL,
  label_dimension = 1L,
  weight_column = NULL,
  optimizer = "Adagrad",
  activation_fn = "relu",
  dropout = NULL,
  input_layer_partitioner = NULL,
  config = NULL
)

dnn_classifier(
  hidden_units,
  feature_columns,
  model_dir = NULL,
  n_classes = 2L,
  weight_column = NULL,
  label_vocabulary = NULL,
  optimizer = "Adagrad",
  activation_fn = "relu",
  dropout = NULL,
  input_layer_partitioner = NULL,
  config = NULL
)
}
\arguments{
\item{hidden_units}{An integer vector, indicating the number of hidden
units in each layer. All layers are fully connected. For example,
\code{c(64, 32)} means the first layer has 64 nodes, and the second layer
has 32 nodes.}

\item{feature_columns}{An \R list containing all of the feature columns used
by the model (typically, generated by \code{\link[=feature_columns]{feature_columns()}}).}

\item{model_dir}{Directory to save the model parameters, graph, and so on.
This can also be used to load checkpoints from the directory into a
estimator to continue training a previously saved model.}

\item{label_dimension}{Number of regression targets per example. This is the
size of the last dimension of the labels and logits \code{Tensor} objects
(typically, these have shape \verb{[batch_size, label_dimension]}).}

\item{weight_column}{A string, or a numeric column created by
\code{\link[=column_numeric]{column_numeric()}} defining feature column representing weights. It is used
to down weight or boost examples during training. It will be multiplied by
the loss of the example. If it is a string, it is used as a key to fetch
weight tensor from the \code{features} argument. If it is a numeric column,
then the raw tensor is fetched by key \code{weight_column$key}, then
\code{weight_column$normalizer_fn} is applied on it to get weight tensor.}

\item{optimizer}{Either the name of the optimizer to be used when training
the model, or a TensorFlow optimizer instance. Defaults to the Adagrad
optimizer.}

\item{activation_fn}{The activation function to apply to each layer. This can either be an
actual activation function (e.g. \code{tf$nn$relu}), or the name of an
activation function (e.g. \code{"relu"}). Defaults to the
\code{"relu"} activation function. See
\url{https://www.tensorflow.org/versions/r1.15/api_docs/python/tf/nn}
for documentation related to the set of activation functions available
in TensorFlow.}

\item{dropout}{When not \code{NULL}, the probability we will drop out a given
coordinate.}

\item{input_layer_partitioner}{An optional partitioner for the input layer.
Defaults to \code{min_max_variable_partitioner} with \code{min_slice_size} 64 << 20.}

\item{config}{A run configuration created by \code{\link[=run_config]{run_config()}}, used to configure the runtime
settings.}

\item{n_classes}{The number of label classes.}

\item{label_vocabulary}{A list of strings represents possible label values.
If given, labels must be string type and have any value in
\code{label_vocabulary}. If it is not given, that means labels are already
encoded as integer or float within \verb{[0, 1]} for \code{n_classes == 2} and
encoded as integer values in \verb{\{0, 1,..., n_classes  -1\}} for \code{n_classes > 2}. Also there will be errors if vocabulary is not provided and labels are
string.}
}
\description{
Create a deep neural network (DNN) estimator.
}
\seealso{
Other canned estimators: 
\code{\link{boosted_trees_estimators}},
\code{\link{dnn_linear_combined_estimators}},
\code{\link{linear_estimators}}
}
\concept{canned estimators}
