% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shuffle_card.R
\name{shuffle_card}
\alias{shuffle_card}
\title{Shuffle \code{cards}}
\usage{
shuffle_card(
  x,
  by = NULL,
  trim = TRUE,
  order_rows = TRUE,
  fill_overall = "Overall {colname}",
  fill_hierarchical_overall = "Any {colname}"
)
}
\arguments{
\item{x}{an ARD data frame of class 'card'}

\item{by}{Grouping variable(s) used in calculations. Defaults to \code{NULL}. If
available (i.e. if \code{x} comes from a stacking function), \code{attributes(x)$by}
will be used instead of \code{by}.}

\item{trim}{logical representing whether or not to trim away \code{fmt_fun},
\code{error}, and \code{warning} columns}

\item{order_rows}{logical representing whether or not to apply
\code{cards::tidy_ard_row_order()} to sort the rows}

\item{fill_overall}{scalar to fill missing grouping or variable levels. If a
character is passed, then it is processed with \code{\link[glue:glue]{glue::glue()}} where the
colname element is available to inject into the string,
e.g. \verb{Overall \{colname\}} may resolve to \code{"Overall AGE"} for an \code{AGE}
column. Default is \verb{Overall \{colname\}}. If \code{NA} then no fill will occur.}

\item{fill_hierarchical_overall}{scalar to fill variable levels for overall
hierarchical calculations. If a character is passed, then it is processed
with \code{\link[glue:glue]{glue::glue()}} where the colname element is available to inject into
the string, e.g. \verb{Any \{colname\}} may resolve to \code{"Any AESOC"} for an
\code{AESOC} column. Default is \verb{Any \{colname\}}. If \code{NA} then no fill will
occur.}
}
\value{
a tibble
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function ingests an ARD object of class \code{card} and shuffles the information to prepare
for analysis. Helpful for streamlining across multiple ARDs.
}
\examples{
\dontrun{
cards::bind_ard(
  cards::ard_categorical(cards::ADSL, by = "ARM", variables = "AGEGR1"),
  cards::ard_categorical(cards::ADSL, variables = "ARM")
) |>
  shuffle_card()
}
}
