% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment_coen.R
\name{evolve_gbmdl}
\alias{evolve_gbmdl}
\alias{junta_1_puntos_cambio}
\alias{junta_k_puntos_cambio}
\alias{mata_1_tau_volado}
\alias{mata_k_tau_volado}
\alias{muta_1_cp_BMDL}
\alias{muta_k_cp_BMDL}
\alias{sim_1_cp_BMDL}
\alias{sim_k_cp_BMDL}
\alias{probs_vec_MDL}
\alias{selec_k_pares_de_padres}
\alias{chromo2tau}
\alias{mat_cp_2_list}
\title{Generate a list of candidate changepoints using a genetic algorithm}
\usage{
evolve_gbmdl(x, mat_cp, these_bmdls)

junta_1_puntos_cambio(padres, mat_cp)

junta_k_puntos_cambio(mat_padres, mat_cp)

mata_1_tau_volado(cp, prob_volado = 0.5)

mata_k_tau_volado(mat_cp)

muta_1_cp_BMDL(
  cp,
  x,
  probs_nuevos_muta0N = c(0.8, 0.1, 0.1),
  dist_extremos = 10,
  min_num_cpts = 1,
  mutation_possibilities = c(-1, 0, 1),
  mutation_probs = c(0.3, 0.4, 0.3),
  max_num_cp = 20
)

muta_k_cp_BMDL(mat_cp, x)

sim_1_cp_BMDL(x, max_num_cp = 20, prob_inicial = 0.06)

sim_k_cp_BMDL(x, generation_size = 50, max_num_cp = 20)

probs_vec_MDL(vec_MDL, probs_rank0_MDL1 = 0)

selec_k_pares_de_padres(vec_probs)

chromo2tau(chromo)

mat_cp_2_list(mat_cp)
}
\arguments{
\item{x}{A time series object}

\item{mat_cp}{A matrix of potential changepoints}

\item{these_bmdls}{vector of \code{\link[=BMDL]{BMDL()}} scores}

\item{padres}{vector de longitud dos con índice de papa e índice de mama}

\item{mat_padres}{matriz de kx2 la cual contiene en sus renglones las
parejas de padres}

\item{cp}{vector cromosoma que se va a poner a prueba}

\item{prob_volado}{probabilidad de quitar un tiempo de cambio existente
utilizado por mata_k_tau_volado para quitar elementos de más. Se recomienda
dejar el valor de 0.5 ya que así al juntar los pc del padre y madre se
eliminará la mitad de estos}

\item{probs_nuevos_muta0N}{probabilidades de mutar 0,1,2,...,l hasta cierto
numero l; eg si vale c(.5,.2,.2,.1) se tiene una probabilidad 0.5 de mutar
0 (de no mutar), probabilidad 0.2 de mutar 1,, probabilidad 0.2 de mutar 2,
y, probabilidad 0.1 de mutar 3.}

\item{dist_extremos}{distancia entre el primer los puntos de cambio v_0 y v_1
al igual que entre v_m y v_\{m+1\}; distancia minima que debe de haber de un
punto de cambio y los valores 1 y T, donde T es la longitud total de la
serie}

\item{min_num_cpts}{es la cota inferior del número de puntos de cambio
que puede tener un cromosoma}

\item{mutation_possibilities}{vector con mutaciones posibles; eg si mutaciones=c(-1,0,1)
entonces un punto de cambio puede ser movido una unidad a la izquierda,
puede quedarse igual, o moverse una unidad a la derecha}

\item{mutation_probs}{probabilidades de mutación. Las longitudes de este vector y
mutaciones tienen que ser iguales; eg si mutaciones=c(-1,0,1) y probs_muta
= c(.2, .6, .2) entonces se tiene una probabilidad .2 de que el punto de
cambio se desplace a la izquierda, probabilidad .6 de quedar igual, y
probabilidad . 2 de ser movido a la derecha}

\item{max_num_cp}{el máximo número de rebases. Este parámetro se ocupa en
particular para que todos los cromosomas quepan en una matriz.}

\item{prob_inicial}{probabilidad de que en la primera generación un punto
cualquiera sea punto de cambio. Se recomienda =.5 ya que con esto se
distribuyen relativamente uniformes los puntos de cambio}

\item{generation_size}{tamaño de las generaciones}

\item{vec_MDL}{vector con valores MDL

OBSERVACIÓN: Esto regresa numeros negativos, los cuales mientras más negativo mejor, ya que
dará que es un mejor vector de tiempos de cambio. Es decir, un MDL de -6000 es
mejor que -4000}

\item{probs_rank0_MDL1}{para medir obtener la probabilidad de los padres se
pueden tomar o las probabilidades con respecto a los rangos (como en el
artículo) o se pueden tomar las probabilidades con respecto a el MDL. La
diferencia radica en que si se toma con respecto al MDL se tendrá que un
cromosoma con un gran MDL este tendrá una gran ventaja de ocurrir, en
cambio cuando solo se tiene rank esta ventaja gran ventaja se reduce}

\item{vec_probs}{vector de probabilidades de selección de cada uno de los
cromosomas}

\item{chromo}{Chromosome, from a row of the matrix \code{mat_cp}}
}
\value{
regresa una matriz de las mismas dimensiones que mat_cp, pero con los
nuevos cromosomas

el mismo cromosoma sin algunos de sus puntos de cambio

regresa una matriz a la cual se le quitaron a sus cromosomas algunos
puntos de cambio

regresa un vector mutado

regreas una mat_cp mutada

regresa una matriz de \code{k} por \code{max_num_cp+3}, la cual en cada renglón tiene
una simulación de un vector de tiempos de cambio

regresa un vector de probabilidades
}
\description{
Generate a list of candidate changepoints using a genetic algorithm
}
\details{
regresa un vector de tamaño \code{max_num_cp+3} donde la primera entrada es
m, la segunda \eqn{v_0=1, ...., v_{m+1}=N,0,...,0}

por ejemplo: \code{c(4,1,3,8,11,15,20,0,0,0,0)} para \code{m=4}, \eqn{max\_num\_cp=8}, \eqn{N=20}.
Se tienen \code{m} puntos de cambio, los cuales
\eqn{\tau_0=1} y \eqn{\tau_{m+1}= N+1},
pero en nuestro caso
tenemos que los vectores \code{cp} tienen \eqn{c(m,\tau_0=1,\tau_1,...,\tau_{m-1},\tau_m= N,0,0,0)}
por lo cual se nosotros:
\itemize{
\item empieza con el número de puntos de cambio;
\item la segunda entrada es un uno;
\item la tercera entrada es el primer punto de cambio;
\item las siguientes son otros puntos de cambio;
\item la siguiente entrada después de punto de cambio tiene el valor  \code{N}; y
\item los siguientes son númores cero hasta llenarlo para que sea de tamaño \code{max_num_cp}
}
}
\examples{
mat_cp <- sim_k_cp_BMDL(DataCPSim)
bmdls <- mat_cp |> 
  mat_cp_2_list() |> 
  evaluate_cpts(.data = as.ts(DataCPSim), model_fn = fit_nhpp) |> 
  dplyr::pull(BMDL)
evolve_gbmdl(exceedances(DataCPSim), mat_cp, bmdls)
sim_1_cp_BMDL(exceedances(DataCPSim))
sim_1_cp_BMDL(exceedances(rlnorm_ts_1))
sim_1_cp_BMDL(exceedances(rlnorm_ts_2))
sim_1_cp_BMDL(exceedances(rlnorm_ts_3))
sim_1_cp_BMDL(exceedances(bogota_pm))

sim_k_cp_BMDL(DataCPSim)

chromo <- c(4, 1, 557, 877 , 905, 986, 1096, 0, 0, 0)
chromo2tau(chromo)
}
\keyword{internal}
