% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_percentiles.R
\name{tab_percentiles}
\alias{tab_percentiles}
\title{Tabulate percentiles for numeric variables}
\usage{
tab_percentiles(
  data,
  ...,
  levels = c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1)
)
}
\arguments{
\item{data}{a \link[tibble:tibble-package]{tibble} or a \link{tdcmm} model that contains the numeric data to be tabulated.}

\item{...}{Variables within the data for which to tabulate the percentiles. If no variables are provided, all numeric variables are used.}

\item{levels}{a numeric vector specifying the percentiles to compute. Defaults to c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0).}
}
\value{
a \link{tdcmm} model
}
\description{
This function tabulates specified percentiles for given numeric variables. If no variables are provided,
the function will attempt to describe all numeric (either integer or double) variables found within the input.
The percentiles are calculated based on the levels parameter, which defaults to every 10\% from 10\% to 90\%.
NA values are always removed because the concept of a percentile is based on
ranking. As NA is not a value, it cannot be ordered in relation to actual numbers.
}
\examples{
WoJ \%>\% tab_percentiles(work_experience)
WoJ \%>\% tab_percentiles(work_experience, autonomy_emphasis)

}
\seealso{
Other descriptives: 
\code{\link{describe}()},
\code{\link{describe_cat}()}
}
\concept{descriptives}
