% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_select.R
\name{index_laslogs}
\alias{index_laslogs}
\title{Build a FAIR index for a folder of LAS files}
\usage{
index_laslogs(dir)
}
\arguments{
\item{dir}{Folder containing .las files}
}
\value{
A list with wells_index, curves_index, files_index
}
\description{
Build a FAIR index for a folder of LAS files
}
\examples{
td <- tempdir()
f1 <- file.path(td, "a.las")
f2 <- file.path(td, "b.las")

las_text <- c(
  " ~Version Information",
  " VERS. 2.0:",
  " WRAP. NO:",
  " ~Well Information",
  " STRT.M 1000:",
  " STOP.M 1001:",
  " STEP.M 1:",
  " NULL. -999.25:",
  " API . 1111111111:",
  " CNTY. TEST:",
  " ~Curve Information",
  " DEPT.M:",
  " GR.API:",
  " ~ASCII Log Data",
  " 1000 80",
  " 1001 82"
)

writeLines(las_text, f1)
writeLines(sub("1111111111", "2222222222", las_text), f2)

idx <- index_laslogs(td)
names(idx)
}
