% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dct_norm.R
\name{norm_dct_wattfab}
\alias{norm_dct_wattfab}
\title{Watt and Fabricius DCT normalization}
\usage{
norm_dct_wattfab(
  .data,
  ...,
  .token_id_col,
  .by = NULL,
  .param_col = NULL,
  .drop_orig = FALSE,
  .names = "{.formant}_wf",
  .silent = opt("tidynorm.silent")
)
}
\arguments{
\item{.data}{A data frame containing vowel formant data}

\item{...}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} One or more unquoted
expressions separated by commas. These should target the vowel formant
data columns.}

\item{.token_id_col}{\code{\link[rlang:args_data_masking]{<data-masking>}} A column
that identifies token ids.}

\item{.by}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} A selection of
columns to group by. Typically a column of speaker IDs.}

\item{.param_col}{A column identifying the DCT parameter number.}

\item{.drop_orig}{Should the originally targeted columns be dropped.}

\item{.names}{A \code{\link[glue:glue]{glue::glue()}} expression for naming the normalized
data columns. The \code{"{.formant}"} portion corresponds to the name of the original
formant columns.}

\item{.silent}{Suppress normalization information messages when running a \verb{norm_*()} function. (Defaults to \code{FALSE}, overwritable using option 'tidynorm.silent' or environment variable 'R_TIDYNORM_TIDYNORM_SILENT')}
}
\value{
A data frame of Watt & Fabricius normalized DCT coefficients.
}
\description{
Watt and Fabricius DCT normalization
}
\details{
This is a modified version of the Watt & Fabricius Method. The original
method identified point vowels over which F1 and F2 centroids were calculated.
The procedure here just identifies centroids by taking the mean of
all formant values.

\deqn{
\hat{F}_{ij} = \frac{F_{ij}}{S_i}
}

\deqn{
 S_i = \frac{1}{N}\sum_{j=1}^N F_{ij}
}

Where
\itemize{
\item \eqn{\hat{F}} is the normalized formant
\item \eqn{i} is the formant number
\item \eqn{j} is the token number
}
}
\examples{
library(tidynorm)
library(dplyr)
ggplot2_inst <- require(ggplot2)

speaker_dct <- speaker_tracks |>
  reframe_with_dct(
    F1:F3,
    .by = speaker,
    .token_id_col = id,
    .time_col = t
  )

# Normalize DCT coefficients
speaker_dct_norm <- speaker_dct |>
  norm_dct_wattfab(
    F1:F3,
    .by = speaker,
    .token_id_col = id,
    .param_col = .param
  )

# Apply average and apply inverse dct
# to plot tracks
track_norm_means <- speaker_dct_norm |>
  summarise(
    .by = c(speaker, vowel, .param),
    across(
      ends_with("_wf"),
      mean
    )
  ) |>
  reframe_with_idct(
    ends_with("_wf"),
    .by = speaker,
    .token_id_col = vowel,
    .param_col = .param
  )


if (ggplot2_inst) {
  track_norm_means |>
    ggplot(
      aes(F2_wf, F1_wf, color = speaker)
    ) +
    geom_path(
      aes(
        group = interaction(speaker, vowel)
      )
    ) +
    scale_x_reverse() +
    scale_y_reverse() +
    scale_color_brewer(palette = "Dark2") +
    coord_fixed()
}
}
\references{
Watt, D., & Fabricius, A. (2002). Evaluation of a technique for improving the
mapping of multiple speakers’ vowel spaces in the F1 ~ F2 plane.
Leeds Working Papers in Linguistics and Phonetics, 9, 159–173.
}
