% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_report_indiv.R
\name{qc_report_indiv}
\alias{qc_report_indiv}
\alias{qc_report_indiv.tbl_df}
\alias{qc_report_indiv.grouped_df}
\title{Create a Quality Control report for individuals}
\usage{
qc_report_indiv(.x, ...)

\method{qc_report_indiv}{tbl_df}(.x, kings_threshold = NULL, ...)

\method{qc_report_indiv}{grouped_df}(.x, kings_threshold = NULL, ...)
}
\arguments{
\item{.x}{either a \code{\link{gen_tibble}} object or a grouped \code{\link{gen_tibble}} (as
obtained by using \code{\link[dplyr:group_by]{dplyr::group_by()}})}

\item{...}{further arguments to pass}

\item{kings_threshold}{an optional numeric giving a KING kinship coefficient,
or one of:
\itemize{
\item "first": removing first degree relatives, equivalent to a kinship
coefficient of 0.177 or more
\item "second": removing second degree relatives, equivalent to a kinship
coefficient of 0.088 or more
}}
}
\value{
If no kings_threshold is provided, a tibble with 2 elements: het_obs
and missingness. If kings_threshold is provided, a tibble with 4 elements:
het_obs, missingness, id and to_keep. For pseudohaploid data, a tibble with
ploidy and missingness.
}
\description{
Return QC information to assess loci (Observed heterozygosity and
missingness).
}
\details{
Providing the parameter kings_threshold will return two additional columns,
'id' containing the ID of individuals, and 'to_keep' a logical vector
describing whether the individual should be removed to retain the largest
possible set of individuals with no relationships above the threshold. The
calculated pairwise KING relationship matrix is also returned as an attribute
of 'to_keep'. The kings_threshold parameter can be either a numeric KING
kinship coefficient or a string of either "first" or "second", to remove any
first degree or second degree relationships from the dataset. This second
option is similar to using  --unrelated --degree 1 or --unrelated --degree 2
in KING. For pseudohaploid data, only missingness and ploidy are reported.
}
\examples{
# Create a gen_tibble of lobster genotypes
bed_file <-
  system.file("extdata", "lobster", "lobster.bed", package = "tidypopgen")
example_gt <- gen_tibble(bed_file,
  backingfile = tempfile("lobsters"),
  quiet = TRUE
)

# Get QC report for individuals
example_gt \%>\% qc_report_indiv()

# Get QC report with kinship filtering
example_gt \%>\% qc_report_indiv(kings_threshold = "first")
}
