% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_convert.R
\name{toon_to_parquet}
\alias{toon_to_parquet}
\title{Convert TOON to Parquet}
\usage{
toon_to_parquet(
  path_toon,
  path_parquet,
  key = NULL,
  strict = TRUE,
  allow_comments = TRUE,
  warn = TRUE
)
}
\arguments{
\item{path_toon}{Character scalar. Path to input TOON file.}

\item{path_parquet}{Character scalar. Path to output Parquet file.}

\item{key}{Character scalar or NULL. If non-NULL, extract tabular array.}

\item{strict}{Logical. If TRUE (default), enforce strict syntax.}

\item{allow_comments}{Logical. If TRUE (default), allow comments.}

\item{warn}{Logical. If TRUE (default), emit warnings.}
}
\value{
Invisibly returns NULL.
}
\description{
Convert TOON to Parquet
}
\details{
Requires the arrow package. If not installed, an error is thrown.
}
\examples{
\dontrun{
toon_to_parquet("data.toon", "data.parquet")
}

}
