% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projectTracks.R
\name{projectTracks}
\alias{projectTracks}
\title{Project tracking data}
\usage{
projectTracks(dataGroup, projType, custom)
}
\arguments{
\item{dataGroup}{data.frame or SpatialPointsDataFrame. Tracking data, with
fields as named by \code{\link{formatFields}}. Must contain 'Latitude' and
'Longitude' columns.}

\item{projType}{character. Select type of equal-area projection to use. Two
options are are available: 'cylin' projects to a World Cylindrical Equal Area
projection, and 'azim' projects to a Lambert Azimuthal EA.}

\item{custom}{logical (TRUE/FALSE). Choose whether projection will use
default centering parameters or whether to set projection center on centroid
of latitude and longitude in dataGroup.

Input data can be tracks split into trips (i.e. output of
\code{\link{tripSplit}})}
}
\value{
Returns a SpatialPointsDataFrame, which can be used for the following
 functions: \code{\link{findScale}}, \code{\link{estSpaceUse}},
 \code{\link{indEffectTest}}, \code{\link{repAssess}}
}
\description{
\code{projectTracks} is a convenience function to project tracking data to a
an equal-area projection for use in kernel density analysis.
}
\details{
Data are transformed to either a World Cylindrical Equal Area, or a Lambert
equal-area projection. Cylindrical projections generally appear better for
data that are distributed more along one axis, while azimuthal appear better
for data that is distributed evenly within a radius. The most important thing
 is that the data are in an equal-area projection for Kernel Density Analysis
 (e.g. \code{\link{estSpaceUse}}).

If \code{custom=TRUE}, the projection will be centered on the data. This
is particularly preferable for data that cross the international dateline,
or near the poles. However, it is important to recognize that this projection
is specific to inpute dataset (i.e. \code{dataGroup}) so if
\code{projectTracks} is run again with even slightly different data, the
projections will differ, which may cause issues down the line if merging
spatial datasets again.

NOTE that these projections may not be the most appropriate for your data and
it is almost certainly better to manually identify a projection appropriate
for your study region. Custom projections are centered on the centroid of
the tracking locations, which is biased for locations close to the poles. In
this case it would be better identify an appropriate polar projection for
your study are instead of relying on \code{projectTracks}. So it is not
strictly necessary for \code{projectTracks} to be used in track2KBA analysis,
 what is important is that an equal-area projection of some kind is used when
 constructing utilization distributions.
}
\examples{

dataGroup <- data.frame(Longitude = c(1, 2, 3, 1), 
                 Latitude =  c(1, 1, 2, 1),
                 ID = rep("A", 4),
                 DateTime = format(
                   lubridate::ymd_hms("2021-01-01 00:00:00") + 
                   lubridate::hours(0:3)
                    )
                 )

## project tracks 
tracks_prj <- projectTracks(
dataGroup, 
projType = "azim", 
custom = "TRUE"
)


}
\seealso{
\code{\link{tripSummary}}
}
