% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ots_strings_processing.R
\name{ots_country_code}
\alias{ots_country_code}
\title{String matching of official country names and ISO-3 codes according to
the United Nations nomenclature}
\usage{
ots_country_code(countryname = NULL)
}
\arguments{
\item{countryname}{A text string such as "Chile", "CHILE" or "CHL".}
}
\value{
A single character if there is a exact match (e.g.
\code{ots_country_code("Chile")}) or a tibble in case of multiple matches
(e.g. \code{ots_country_code("Germany")})
}
\description{
Takes a text string and searches within the
package data for a country code in the context of valid API country codes.
}
\examples{
ots_country_code("Chile ")
ots_country_code("america")
ots_country_code("UNITED  STATES")
ots_country_code(" united_")
}
\keyword{functions}
