% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{hresiduals.tsissm.estimate}
\alias{hresiduals.tsissm.estimate}
\alias{hresiduals}
\title{Multi-Step Ahead In-Sample Residuals}
\usage{
\method{hresiduals}{tsissm.estimate}(
  object,
  h = 12,
  transformed = TRUE,
  index_start = 0,
  simplify = TRUE,
  ...
)

hresiduals(object, ...)
}
\arguments{
\item{object}{an object of class \dQuote{tsissm.estimate}.}

\item{h}{the forecast horizon}

\item{transformed}{residuals based values in transformed space (Box Cox).}

\item{index_start}{the time point from which to initiate the in-sample rolling 
forecasts. This is zero based to enable the first forecast to be t=1.}

\item{simplify}{whether to return a matrix type data.table of error against
date and horizon, else the long for data.table with the forecasts, actuals and
errors.}

\item{...}{not currently used.}
}
\value{
A data.table in either long or wide format.
}
\description{
Extract the multi-step ahead in-sample residual values from an estimated model.
}
\details{
For each time point t (t>=index_start), in the data sample, an h-steps ahead 
forecast  (predicting the observation at time t + h) is made, using the full sample 
estimated parameters and observed data up to t. These h-step-ahead fitted residuals,
in either transformed or untransformed space, can sometimes be used for diagnosing
the multi-step ahead in-sample performance of the model. This is not a substitute 
for a proper rolling out of sample forecast, but a quick method which may still
be useful.
}
