% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble.R
\name{tsensemble.tsissm.selection}
\alias{tsensemble.tsissm.selection}
\alias{tsensemble}
\alias{tsensemble.tsissm.selection_predict}
\alias{tsensemble.tsissm.selection_simulate}
\title{Ensembling of Models and Predictions}
\usage{
\method{tsensemble}{tsissm.selection}(object, weights = NULL, start = 1, ...)

\method{tsensemble}{tsissm.selection_predict}(object, weights = NULL, start = 1, ...)

\method{tsensemble}{tsissm.selection_simulate}(object, weights = NULL, start = 1, ...)
}
\arguments{
\item{object}{an object of class \dQuote{tsissm.selection}, \dQuote{tsissm.selection_predict} or
\dQuote{tsissm.selection_simulate}.}

\item{weights}{a vector of weights equal to the number of models to be ensembled.}

\item{start}{the index for the state decomposition (when all lambda equal). If 1,
will return the predicted states else will return the lagged predicted states (which
can be summed to return the predictive distribution).}

\item{...}{not used.}
}
\value{
For the estimated object, a list with the weighted fit and errors, whilst
for the predicted and simulated objects a list with the ensemble predictions
as a \dQuote{tsmodel.predict} object. If the models were all estimated with
the same Box Cox lambda, then the weighted state decomposition is also returned
inside the \dQuote{tsmodel.predict} object.
Additionally, for the predicted object, the ensemble analytic mean is also returned.
}
\description{
Ensembles estimated, predicted and simulated objects arising from the automatic selection method.
}
\note{
Only the size of the weights is checked (should be equal to number of selected models),
but not checks are performed on the values of the weights or whether they sum to 1. This
is left to the user.
When lambda is 1, the sum of component will be off by 1 versus the weighted distribution
since the Box Cox transform contains an offset (so it is to be expected). To replicate the
value of the predicted distribution by summing the decomposed components, the argument
\dQuote{start} should be set to 0 to return the lagged predicted components.
}
