// Generated by rstantools.  Do not edit by hand.

/*
    tsnet is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    tsnet is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with tsnet.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_VAR_LKJ_beep_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 110> locations_array__ =
  {" (found before start of program)",
  " (in 'string', line 27, column 2 to column 23)",
  " (in 'string', line 31, column 2 to column 34)",
  " (in 'string', line 32, column 2 to column 24)",
  " (in 'string', line 37, column 2 to column 67)",
  " (in 'string', line 40, column 2 to line 41, column 68)",
  " (in 'string', line 43, column 2 to column 18)",
  " (in 'string', line 88, column 2 to column 28)",
  " (in 'string', line 89, column 2 to column 28)",
  " (in 'string', line 95, column 2 to column 73)",
  " (in 'string', line 46, column 11 to column 12)",
  " (in 'string', line 46, column 13 to column 14)",
  " (in 'string', line 46, column 4 to column 43)",
  " (in 'string', line 52, column 10 to column 23)",
  " (in 'string', line 51, column 13 to line 53, column 9)",
  " (in 'string', line 50, column 10 to column 65)",
  " (in 'string', line 49, column 18 to line 51, column 9)",
  " (in 'string', line 49, column 8 to line 53, column 9)",
  " (in 'string', line 48, column 19 to line 54, column 7)",
  " (in 'string', line 48, column 6 to line 54, column 7)",
  " (in 'string', line 47, column 17 to line 55, column 5)",
  " (in 'string', line 47, column 4 to line 55, column 5)",
  " (in 'string', line 44, column 2 to line 56, column 3)",
  " (in 'string', line 92, column 4 to column 19)",
  " (in 'string', line 91, column 27 to line 93, column 3)",
  " (in 'string', line 91, column 2 to line 93, column 3)",
  " (in 'string', line 98, column 13 to column 14)",
  " (in 'string', line 98, column 6 to column 36)",
  " (in 'string', line 100, column 6 to column 71)",
  " (in 'string', line 97, column 30 to line 101, column 5)",
  " (in 'string', line 97, column 4 to line 101, column 5)",
  " (in 'string', line 96, column 17 to line 102, column 3)",
  " (in 'string', line 96, column 2 to line 102, column 3)",
  " (in 'string', line 105, column 10 to column 15)",
  " (in 'string', line 105, column 24 to column 25)",
  " (in 'string', line 105, column 4 to column 38)",
  " (in 'string', line 106, column 11 to column 12)",
  " (in 'string', line 106, column 4 to column 31)",
  " (in 'string', line 108, column 13 to column 14)",
  " (in 'string', line 108, column 6 to column 38)",
  " (in 'string', line 109, column 6 to column 64)",
  " (in 'string', line 110, column 6 to column 27)",
  " (in 'string', line 111, column 6 to column 32)",
  " (in 'string', line 114, column 8 to column 82)",
  " (in 'string', line 113, column 32 to line 115, column 5)",
  " (in 'string', line 113, column 6 to line 115, column 5)",
  " (in 'string', line 107, column 23 to line 116, column 3)",
  " (in 'string', line 107, column 4 to line 116, column 3)",
  " (in 'string', line 103, column 15 to line 117, column 3)",
  " (in 'string', line 103, column 2 to line 117, column 3)",
  " (in 'string', line 61, column 2 to column 50)",
  " (in 'string', line 62, column 2 to column 55)",
  " (in 'string', line 63, column 2 to column 49)",
  " (in 'string', line 70, column 8 to line 71, column 73)",
  " (in 'string', line 67, column 15 to line 72, column 9)",
  " (in 'string', line 67, column 6 to line 72, column 9)",
  " (in 'string', line 66, column 17 to line 73, column 7)",
  " (in 'string', line 66, column 4 to line 73, column 7)",
  " (in 'string', line 65, column 15 to line 74, column 5)",
  " (in 'string', line 65, column 2 to line 74, column 5)",
  " (in 'string', line 77, column 11 to column 12)",
  " (in 'string', line 77, column 14 to column 15)",
  " (in 'string', line 77, column 4 to column 75)",
  " (in 'string', line 80, column 15 to column 16)",
  " (in 'string', line 80, column 8 to column 38)",
  " (in 'string', line 81, column 8 to column 69)",
  " (in 'string', line 79, column 30 to line 82, column 7)",
  " (in 'string', line 79, column 6 to line 82, column 7)",
  " (in 'string', line 78, column 17 to line 83, column 5)",
  " (in 'string', line 78, column 4 to line 83, column 5)",
  " (in 'string', line 75, column 2 to line 84, column 3)",
  " (in 'string', line 5, column 2 to column 17)",
  " (in 'string', line 6, column 2 to column 17)",
  " (in 'string', line 7, column 8 to column 9)",
  " (in 'string', line 7, column 2 to column 20)",
  " (in 'string', line 8, column 8 to column 9)",
  " (in 'string', line 8, column 18 to column 19)",
  " (in 'string', line 8, column 2 to column 23)",
  " (in 'string', line 10, column 9 to column 10)",
  " (in 'string', line 10, column 11 to column 12)",
  " (in 'string', line 10, column 2 to column 29)",
  " (in 'string', line 11, column 9 to column 10)",
  " (in 'string', line 11, column 11 to column 12)",
  " (in 'string', line 11, column 2 to column 31)",
  " (in 'string', line 12, column 9 to column 10)",
  " (in 'string', line 12, column 11 to column 12)",
  " (in 'string', line 12, column 2 to column 28)",
  " (in 'string', line 13, column 9 to column 10)",
  " (in 'string', line 13, column 11 to column 12)",
  " (in 'string', line 13, column 2 to column 30)",
  " (in 'string', line 14, column 2 to column 25)",
  " (in 'string', line 16, column 2 to column 21)",
  " (in 'string', line 17, column 2 to column 44)",
  " (in 'string', line 18, column 8 to column 13)",
  " (in 'string', line 18, column 22 to column 23)",
  " (in 'string', line 18, column 2 to column 34)",
  " (in 'string', line 22, column 2 to column 29)",
  " (in 'string', line 27, column 9 to column 10)",
  " (in 'string', line 27, column 11 to column 12)",
  " (in 'string', line 31, column 23 to column 24)",
  " (in 'string', line 32, column 9 to column 10)",
  " (in 'string', line 37, column 9 to column 10)",
  " (in 'string', line 37, column 11 to column 12)",
  " (in 'string', line 40, column 9 to column 10)",
  " (in 'string', line 40, column 11 to column 12)",
  " (in 'string', line 43, column 9 to column 10)",
  " (in 'string', line 43, column 11 to column 12)",
  " (in 'string', line 89, column 9 to column 18)",
  " (in 'string', line 95, column 9 to column 10)",
  " (in 'string', line 95, column 12 to column 13)"};
#include <stan_meta_header.hpp>
class model_VAR_LKJ_beep final : public model_base_crtp<model_VAR_LKJ_beep> {
private:
  int K;
  int T;
  std::vector<int> beep;
  std::vector<Eigen::Matrix<double,-1,1>> Y;
  Eigen::Matrix<double,-1,-1> prior_Beta_loc_data__;
  Eigen::Matrix<double,-1,-1> prior_Beta_scale_data__;
  Eigen::Matrix<double,-1,-1> prior_Rho_loc_data__;
  Eigen::Matrix<double,-1,-1> prior_Rho_scale_data__;
  int prior_Eta;
  int ahead;
  int compute_log_lik;
  std::vector<Eigen::Matrix<double,-1,1>> Y_future;
  int first_beep;
  int log_lik_1dim__;
  Eigen::Map<Eigen::Matrix<double,-1,-1>> prior_Beta_loc{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> prior_Beta_scale{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> prior_Rho_loc{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> prior_Rho_scale{nullptr, 0, 0};
public:
  ~model_VAR_LKJ_beep() {}
  model_VAR_LKJ_beep(stan::io::var_context& context__, unsigned int
                     random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_VAR_LKJ_beep_namespace::model_VAR_LKJ_beep";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 71;
      context__.validate_dims("data initialization", "K", "int",
        std::vector<size_t>{});
      K = std::numeric_limits<int>::min();
      current_statement__ = 71;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 71;
      stan::math::check_greater_or_equal(function__, "K", K, 0);
      current_statement__ = 72;
      context__.validate_dims("data initialization", "T", "int",
        std::vector<size_t>{});
      T = std::numeric_limits<int>::min();
      current_statement__ = 72;
      T = context__.vals_i("T")[(1 - 1)];
      current_statement__ = 72;
      stan::math::check_greater_or_equal(function__, "T", T, 0);
      current_statement__ = 73;
      stan::math::validate_non_negative_index("beep", "T", T);
      current_statement__ = 74;
      context__.validate_dims("data initialization", "beep", "int",
        std::vector<size_t>{static_cast<size_t>(T)});
      beep = std::vector<int>(T, std::numeric_limits<int>::min());
      current_statement__ = 74;
      beep = context__.vals_i("beep");
      current_statement__ = 75;
      stan::math::validate_non_negative_index("Y", "T", T);
      current_statement__ = 76;
      stan::math::validate_non_negative_index("Y", "K", K);
      current_statement__ = 77;
      context__.validate_dims("data initialization", "Y", "double",
        std::vector<size_t>{static_cast<size_t>(T), static_cast<size_t>(K)});
      Y = std::vector<Eigen::Matrix<double,-1,1>>(T,
            Eigen::Matrix<double,-1,1>::Constant(K,
              std::numeric_limits<double>::quiet_NaN()));
      {
        std::vector<local_scalar_t__> Y_flat__;
        current_statement__ = 77;
        Y_flat__ = context__.vals_r("Y");
        current_statement__ = 77;
        pos__ = 1;
        current_statement__ = 77;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 77;
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            current_statement__ = 77;
            stan::model::assign(Y, Y_flat__[(pos__ - 1)],
              "assigning variable Y", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 77;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 78;
      stan::math::validate_non_negative_index("prior_Beta_loc", "K", K);
      current_statement__ = 79;
      stan::math::validate_non_negative_index("prior_Beta_loc", "K", K);
      current_statement__ = 80;
      context__.validate_dims("data initialization", "prior_Beta_loc",
        "double",
        std::vector<size_t>{static_cast<size_t>(K), static_cast<size_t>(K)});
      prior_Beta_loc_data__ = Eigen::Matrix<double,-1,-1>::Constant(K, K,
                                std::numeric_limits<double>::quiet_NaN());
      new (&prior_Beta_loc)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(prior_Beta_loc_data__.data(),
        K, K);
      {
        std::vector<local_scalar_t__> prior_Beta_loc_flat__;
        current_statement__ = 80;
        prior_Beta_loc_flat__ = context__.vals_r("prior_Beta_loc");
        current_statement__ = 80;
        pos__ = 1;
        current_statement__ = 80;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 80;
          for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
            current_statement__ = 80;
            stan::model::assign(prior_Beta_loc, prior_Beta_loc_flat__[(pos__
              - 1)], "assigning variable prior_Beta_loc",
              stan::model::index_uni(sym2__), stan::model::index_uni(sym1__));
            current_statement__ = 80;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 81;
      stan::math::validate_non_negative_index("prior_Beta_scale", "K", K);
      current_statement__ = 82;
      stan::math::validate_non_negative_index("prior_Beta_scale", "K", K);
      current_statement__ = 83;
      context__.validate_dims("data initialization", "prior_Beta_scale",
        "double",
        std::vector<size_t>{static_cast<size_t>(K), static_cast<size_t>(K)});
      prior_Beta_scale_data__ = Eigen::Matrix<double,-1,-1>::Constant(K, K,
                                  std::numeric_limits<double>::quiet_NaN());
      new (&prior_Beta_scale)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(prior_Beta_scale_data__.data(),
        K, K);
      {
        std::vector<local_scalar_t__> prior_Beta_scale_flat__;
        current_statement__ = 83;
        prior_Beta_scale_flat__ = context__.vals_r("prior_Beta_scale");
        current_statement__ = 83;
        pos__ = 1;
        current_statement__ = 83;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 83;
          for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
            current_statement__ = 83;
            stan::model::assign(prior_Beta_scale,
              prior_Beta_scale_flat__[(pos__ - 1)],
              "assigning variable prior_Beta_scale",
              stan::model::index_uni(sym2__), stan::model::index_uni(sym1__));
            current_statement__ = 83;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 84;
      stan::math::validate_non_negative_index("prior_Rho_loc", "K", K);
      current_statement__ = 85;
      stan::math::validate_non_negative_index("prior_Rho_loc", "K", K);
      current_statement__ = 86;
      context__.validate_dims("data initialization", "prior_Rho_loc",
        "double",
        std::vector<size_t>{static_cast<size_t>(K), static_cast<size_t>(K)});
      prior_Rho_loc_data__ = Eigen::Matrix<double,-1,-1>::Constant(K, K,
                               std::numeric_limits<double>::quiet_NaN());
      new (&prior_Rho_loc)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(prior_Rho_loc_data__.data(),
        K, K);
      {
        std::vector<local_scalar_t__> prior_Rho_loc_flat__;
        current_statement__ = 86;
        prior_Rho_loc_flat__ = context__.vals_r("prior_Rho_loc");
        current_statement__ = 86;
        pos__ = 1;
        current_statement__ = 86;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 86;
          for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
            current_statement__ = 86;
            stan::model::assign(prior_Rho_loc, prior_Rho_loc_flat__[(pos__ -
              1)], "assigning variable prior_Rho_loc",
              stan::model::index_uni(sym2__), stan::model::index_uni(sym1__));
            current_statement__ = 86;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 87;
      stan::math::validate_non_negative_index("prior_Rho_scale", "K", K);
      current_statement__ = 88;
      stan::math::validate_non_negative_index("prior_Rho_scale", "K", K);
      current_statement__ = 89;
      context__.validate_dims("data initialization", "prior_Rho_scale",
        "double",
        std::vector<size_t>{static_cast<size_t>(K), static_cast<size_t>(K)});
      prior_Rho_scale_data__ = Eigen::Matrix<double,-1,-1>::Constant(K, K,
                                 std::numeric_limits<double>::quiet_NaN());
      new (&prior_Rho_scale)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(prior_Rho_scale_data__.data(),
        K, K);
      {
        std::vector<local_scalar_t__> prior_Rho_scale_flat__;
        current_statement__ = 89;
        prior_Rho_scale_flat__ = context__.vals_r("prior_Rho_scale");
        current_statement__ = 89;
        pos__ = 1;
        current_statement__ = 89;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 89;
          for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
            current_statement__ = 89;
            stan::model::assign(prior_Rho_scale,
              prior_Rho_scale_flat__[(pos__ - 1)],
              "assigning variable prior_Rho_scale",
              stan::model::index_uni(sym2__), stan::model::index_uni(sym1__));
            current_statement__ = 89;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 90;
      context__.validate_dims("data initialization", "prior_Eta", "int",
        std::vector<size_t>{});
      prior_Eta = std::numeric_limits<int>::min();
      current_statement__ = 90;
      prior_Eta = context__.vals_i("prior_Eta")[(1 - 1)];
      current_statement__ = 90;
      stan::math::check_greater_or_equal(function__, "prior_Eta", prior_Eta,
        1);
      current_statement__ = 91;
      context__.validate_dims("data initialization", "ahead", "int",
        std::vector<size_t>{});
      ahead = std::numeric_limits<int>::min();
      current_statement__ = 91;
      ahead = context__.vals_i("ahead")[(1 - 1)];
      current_statement__ = 91;
      stan::math::check_greater_or_equal(function__, "ahead", ahead, 0);
      current_statement__ = 92;
      context__.validate_dims("data initialization", "compute_log_lik",
        "int", std::vector<size_t>{});
      compute_log_lik = std::numeric_limits<int>::min();
      current_statement__ = 92;
      compute_log_lik = context__.vals_i("compute_log_lik")[(1 - 1)];
      current_statement__ = 92;
      stan::math::check_greater_or_equal(function__, "compute_log_lik",
        compute_log_lik, 0);
      current_statement__ = 92;
      stan::math::check_less_or_equal(function__, "compute_log_lik",
        compute_log_lik, 1);
      current_statement__ = 93;
      stan::math::validate_non_negative_index("Y_future", "ahead", ahead);
      current_statement__ = 94;
      stan::math::validate_non_negative_index("Y_future", "K", K);
      current_statement__ = 95;
      context__.validate_dims("data initialization", "Y_future", "double",
        std::vector<size_t>{static_cast<size_t>(ahead),
          static_cast<size_t>(K)});
      Y_future = std::vector<Eigen::Matrix<double,-1,1>>(ahead,
                   Eigen::Matrix<double,-1,1>::Constant(K,
                     std::numeric_limits<double>::quiet_NaN()));
      {
        std::vector<local_scalar_t__> Y_future_flat__;
        current_statement__ = 95;
        Y_future_flat__ = context__.vals_r("Y_future");
        current_statement__ = 95;
        pos__ = 1;
        current_statement__ = 95;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 95;
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            current_statement__ = 95;
            stan::model::assign(Y_future, Y_future_flat__[(pos__ - 1)],
              "assigning variable Y_future", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 95;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 96;
      first_beep = std::numeric_limits<int>::min();
      current_statement__ = 96;
      first_beep = stan::math::min(beep);
      current_statement__ = 97;
      stan::math::validate_non_negative_index("Beta_raw", "K", K);
      current_statement__ = 98;
      stan::math::validate_non_negative_index("Beta_raw", "K", K);
      current_statement__ = 99;
      stan::math::validate_non_negative_index("L_Theta", "K", K);
      current_statement__ = 99;
      stan::math::validate_non_negative_index("L_Theta", "K", K);
      current_statement__ = 100;
      stan::math::validate_non_negative_index("sigma_theta", "K", K);
      current_statement__ = 101;
      stan::math::validate_non_negative_index("Beta", "K", K);
      current_statement__ = 102;
      stan::math::validate_non_negative_index("Beta", "K", K);
      current_statement__ = 103;
      stan::math::validate_non_negative_index("Sigma", "K", K);
      current_statement__ = 104;
      stan::math::validate_non_negative_index("Sigma", "K", K);
      current_statement__ = 105;
      stan::math::validate_non_negative_index("Rho", "K", K);
      current_statement__ = 106;
      stan::math::validate_non_negative_index("Rho", "K", K);
      current_statement__ = 107;
      log_lik_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 107;
      log_lik_1dim__ = (T + ahead);
      current_statement__ = 107;
      stan::math::validate_non_negative_index("log_lik", "T + ahead",
        log_lik_1dim__);
      current_statement__ = 108;
      stan::math::validate_non_negative_index("Sigma_chol", "K", K);
      current_statement__ = 109;
      stan::math::validate_non_negative_index("Sigma_chol", "K", K);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = (K * K) + ((K * (K - 1)) / 2) + K;
  }
  inline std::string model_name() const final {
    return "model_VAR_LKJ_beep";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_VAR_LKJ_beep_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,-1> Beta_raw =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(K, K, DUMMY_VAR__);
      current_statement__ = 1;
      Beta_raw = in__.template read<Eigen::Matrix<local_scalar_t__,-1,-1>>(K,
                   K);
      Eigen::Matrix<local_scalar_t__,-1,-1> L_Theta =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(K, K, DUMMY_VAR__);
      current_statement__ = 2;
      L_Theta = in__.template read_constrain_cholesky_factor_corr<
                  Eigen::Matrix<local_scalar_t__,-1,-1>, jacobian__>(lp__, K);
      Eigen::Matrix<local_scalar_t__,-1,1> sigma_theta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      current_statement__ = 3;
      sigma_theta = in__.template read<
                      Eigen::Matrix<local_scalar_t__,-1,1>>(K);
      Eigen::Matrix<local_scalar_t__,-1,-1> Beta =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(K, K, DUMMY_VAR__);
      current_statement__ = 4;
      stan::model::assign(Beta,
        stan::math::add(stan::math::elt_multiply(Beta_raw, prior_Beta_scale),
          prior_Beta_loc), "assigning variable Beta");
      Eigen::Matrix<local_scalar_t__,-1,-1> Sigma =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(K, K, DUMMY_VAR__);
      current_statement__ = 5;
      stan::model::assign(Sigma,
        stan::math::multiply(
          stan::math::diag_pre_multiply(stan::math::exp(sigma_theta), L_Theta),
          stan::math::transpose(
            stan::math::diag_pre_multiply(stan::math::exp(sigma_theta),
              L_Theta))), "assigning variable Sigma");
      Eigen::Matrix<local_scalar_t__,-1,-1> Rho =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(K, K, DUMMY_VAR__);
      {
        current_statement__ = 10;
        stan::math::validate_non_negative_index("Theta", "K", K);
        current_statement__ = 11;
        stan::math::validate_non_negative_index("Theta", "K", K);
        Eigen::Matrix<local_scalar_t__,-1,-1> Theta =
          Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(K, K, DUMMY_VAR__);
        current_statement__ = 12;
        stan::model::assign(Theta, stan::math::inverse_spd(Sigma),
          "assigning variable Theta");
        current_statement__ = 21;
        for (int i = 1; i <= K; ++i) {
          current_statement__ = 19;
          for (int j = 1; j <= K; ++j) {
            current_statement__ = 17;
            if (stan::math::logical_neq(i, j)) {
              current_statement__ = 15;
              stan::model::assign(Rho,
                (-stan::model::rvalue(Theta, "Theta",
                    stan::model::index_uni(i), stan::model::index_uni(j)) /
                stan::math::sqrt(
                  (stan::model::rvalue(Theta, "Theta",
                     stan::model::index_uni(i), stan::model::index_uni(i)) *
                  stan::model::rvalue(Theta, "Theta",
                    stan::model::index_uni(j), stan::model::index_uni(j))))),
                "assigning variable Rho", stan::model::index_uni(i),
                stan::model::index_uni(j));
            } else {
              current_statement__ = 13;
              stan::model::assign(Rho, 0, "assigning variable Rho",
                stan::model::index_uni(i), stan::model::index_uni(j));
            }
          }
        }
      }
      {
        current_statement__ = 50;
        lp_accum__.add(stan::math::std_normal_lpdf<false>(
                         stan::math::to_vector(Beta_raw)));
        current_statement__ = 51;
        lp_accum__.add(stan::math::lkj_corr_cholesky_lpdf<false>(L_Theta,
                         prior_Eta));
        current_statement__ = 52;
        lp_accum__.add(stan::math::student_t_lpdf<false>(sigma_theta, 3, 0, 2));
        current_statement__ = 59;
        for (int i = 1; i <= K; ++i) {
          current_statement__ = 57;
          for (int j = 1; j <= K; ++j) {
            current_statement__ = 55;
            if (stan::math::logical_lt(i, j)) {
              current_statement__ = 53;
              lp_accum__.add(stan::math::beta_proportion_lpdf<false>(
                               ((stan::model::rvalue(Rho, "Rho",
                                   stan::model::index_uni(i),
                                   stan::model::index_uni(j)) / 2) + 0.5),
                               stan::model::rvalue(prior_Rho_loc,
                                 "prior_Rho_loc", stan::model::index_uni(i),
                                 stan::model::index_uni(j)),
                               stan::model::rvalue(prior_Rho_scale,
                                 "prior_Rho_scale",
                                 stan::model::index_uni(i),
                                 stan::model::index_uni(j))));
            }
          }
        }
        {
          current_statement__ = 60;
          stan::math::validate_non_negative_index("Sigma_chol", "K", K);
          current_statement__ = 61;
          stan::math::validate_non_negative_index("Sigma_chol", "K", K);
          Eigen::Matrix<local_scalar_t__,-1,-1> Sigma_chol =
            Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(K, K,
              DUMMY_VAR__);
          current_statement__ = 62;
          stan::model::assign(Sigma_chol,
            stan::math::diag_pre_multiply(stan::math::exp(sigma_theta),
              L_Theta), "assigning variable Sigma_chol");
          current_statement__ = 69;
          for (int t = 2; t <= T; ++t) {
            current_statement__ = 67;
            if (stan::math::logical_gt(
                  stan::model::rvalue(beep, "beep", stan::model::index_uni(t)),
                  first_beep)) {
              current_statement__ = 63;
              stan::math::validate_non_negative_index("mu", "K", K);
              Eigen::Matrix<local_scalar_t__,-1,1> mu =
                Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K,
                  DUMMY_VAR__);
              current_statement__ = 64;
              stan::model::assign(mu,
                stan::math::multiply(Beta,
                  stan::model::rvalue(Y, "Y",
                    stan::model::index_uni((t - 1)),
                    stan::model::index_omni())), "assigning variable mu");
              current_statement__ = 65;
              lp_accum__.add(stan::math::multi_normal_cholesky_lpdf<false>(
                               stan::model::rvalue(Y, "Y",
                                 stan::model::index_uni(t),
                                 stan::model::index_omni()), mu, Sigma_chol));
            }
          }
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_VAR_LKJ_beep_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,-1> Beta_raw =
        Eigen::Matrix<double,-1,-1>::Constant(K, K,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      Beta_raw = in__.template read<Eigen::Matrix<local_scalar_t__,-1,-1>>(K,
                   K);
      Eigen::Matrix<double,-1,-1> L_Theta =
        Eigen::Matrix<double,-1,-1>::Constant(K, K,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      L_Theta = in__.template read_constrain_cholesky_factor_corr<
                  Eigen::Matrix<local_scalar_t__,-1,-1>, jacobian__>(lp__, K);
      Eigen::Matrix<double,-1,1> sigma_theta =
        Eigen::Matrix<double,-1,1>::Constant(K,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 3;
      sigma_theta = in__.template read<
                      Eigen::Matrix<local_scalar_t__,-1,1>>(K);
      Eigen::Matrix<double,-1,-1> Beta =
        Eigen::Matrix<double,-1,-1>::Constant(K, K,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,-1> Sigma =
        Eigen::Matrix<double,-1,-1>::Constant(K, K,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,-1> Rho =
        Eigen::Matrix<double,-1,-1>::Constant(K, K,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(Beta_raw);
      out__.write(L_Theta);
      out__.write(sigma_theta);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 4;
      stan::model::assign(Beta,
        stan::math::add(stan::math::elt_multiply(Beta_raw, prior_Beta_scale),
          prior_Beta_loc), "assigning variable Beta");
      current_statement__ = 5;
      stan::model::assign(Sigma,
        stan::math::multiply(
          stan::math::diag_pre_multiply(stan::math::exp(sigma_theta), L_Theta),
          stan::math::transpose(
            stan::math::diag_pre_multiply(stan::math::exp(sigma_theta),
              L_Theta))), "assigning variable Sigma");
      {
        current_statement__ = 10;
        stan::math::validate_non_negative_index("Theta", "K", K);
        current_statement__ = 11;
        stan::math::validate_non_negative_index("Theta", "K", K);
        Eigen::Matrix<double,-1,-1> Theta =
          Eigen::Matrix<double,-1,-1>::Constant(K, K,
            std::numeric_limits<double>::quiet_NaN());
        current_statement__ = 12;
        stan::model::assign(Theta, stan::math::inverse_spd(Sigma),
          "assigning variable Theta");
        current_statement__ = 21;
        for (int i = 1; i <= K; ++i) {
          current_statement__ = 19;
          for (int j = 1; j <= K; ++j) {
            current_statement__ = 17;
            if (stan::math::logical_neq(i, j)) {
              current_statement__ = 15;
              stan::model::assign(Rho,
                (-stan::model::rvalue(Theta, "Theta",
                    stan::model::index_uni(i), stan::model::index_uni(j)) /
                stan::math::sqrt(
                  (stan::model::rvalue(Theta, "Theta",
                     stan::model::index_uni(i), stan::model::index_uni(i)) *
                  stan::model::rvalue(Theta, "Theta",
                    stan::model::index_uni(j), stan::model::index_uni(j))))),
                "assigning variable Rho", stan::model::index_uni(i),
                stan::model::index_uni(j));
            } else {
              current_statement__ = 13;
              stan::model::assign(Rho, 0, "assigning variable Rho",
                stan::model::index_uni(i), stan::model::index_uni(j));
            }
          }
        }
      }
      if (emit_transformed_parameters__) {
        out__.write(Beta);
        out__.write(Sigma);
        out__.write(Rho);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      int min_beep = std::numeric_limits<int>::min();
      current_statement__ = 7;
      min_beep = first_beep;
      Eigen::Matrix<double,-1,1> log_lik =
        Eigen::Matrix<double,-1,1>::Constant(log_lik_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 25;
      for (int t = 1; t <= (T + ahead); ++t) {
        current_statement__ = 23;
        stan::model::assign(log_lik, 0, "assigning variable log_lik",
          stan::model::index_uni(t));
      }
      Eigen::Matrix<double,-1,-1> Sigma_chol =
        Eigen::Matrix<double,-1,-1>::Constant(K, K,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 9;
      stan::model::assign(Sigma_chol,
        stan::math::diag_pre_multiply(stan::math::exp(sigma_theta), L_Theta),
        "assigning variable Sigma_chol");
      current_statement__ = 32;
      for (int t = 2; t <= T; ++t) {
        current_statement__ = 30;
        if (stan::math::logical_gt(
              stan::model::rvalue(beep, "beep", stan::model::index_uni(t)),
              first_beep)) {
          current_statement__ = 26;
          stan::math::validate_non_negative_index("mu", "K", K);
          Eigen::Matrix<double,-1,1> mu =
            Eigen::Matrix<double,-1,1>::Constant(K,
              std::numeric_limits<double>::quiet_NaN());
          current_statement__ = 27;
          stan::model::assign(mu,
            stan::math::multiply(Beta,
              stan::model::rvalue(Y, "Y", stan::model::index_uni((t - 1)),
                stan::model::index_omni())), "assigning variable mu");
          current_statement__ = 28;
          stan::model::assign(log_lik,
            stan::math::multi_normal_cholesky_lpdf<false>(
              stan::model::rvalue(Y, "Y", stan::model::index_uni(t),
                stan::model::index_omni()), mu, Sigma_chol),
            "assigning variable log_lik", stan::model::index_uni(t));
        }
      }
      current_statement__ = 49;
      if (stan::math::logical_gt(ahead, 0)) {
        current_statement__ = 33;
        stan::math::validate_non_negative_index("Y_forecast", "ahead", ahead);
        current_statement__ = 34;
        stan::math::validate_non_negative_index("Y_forecast", "K", K);
        std::vector<Eigen::Matrix<double,-1,1>> Y_forecast =
          std::vector<Eigen::Matrix<double,-1,1>>(ahead,
            Eigen::Matrix<double,-1,1>::Constant(K,
              std::numeric_limits<double>::quiet_NaN()));
        current_statement__ = 36;
        stan::math::validate_non_negative_index("current_Y", "K", K);
        Eigen::Matrix<double,-1,1> current_Y =
          Eigen::Matrix<double,-1,1>::Constant(K,
            std::numeric_limits<double>::quiet_NaN());
        current_statement__ = 37;
        stan::model::assign(current_Y,
          stan::model::rvalue(Y, "Y", stan::model::index_uni(T)),
          "assigning variable current_Y");
        current_statement__ = 47;
        for (int s = 1; s <= ahead; ++s) {
          current_statement__ = 38;
          stan::math::validate_non_negative_index("mu", "K", K);
          Eigen::Matrix<double,-1,1> mu =
            Eigen::Matrix<double,-1,1>::Constant(K,
              std::numeric_limits<double>::quiet_NaN());
          current_statement__ = 39;
          stan::model::assign(mu, stan::math::multiply(Beta, current_Y),
            "assigning variable mu");
          current_statement__ = 40;
          stan::model::assign(Y_forecast,
            stan::math::multi_normal_cholesky_rng(mu, Sigma_chol, base_rng__),
            "assigning variable Y_forecast", stan::model::index_uni(s));
          current_statement__ = 41;
          if (pstream__) {
            stan::math::stan_print(pstream__,
              stan::model::rvalue(Y_forecast, "Y_forecast",
                stan::model::index_uni(s)));
            *(pstream__) << std::endl;
          }
          current_statement__ = 42;
          stan::model::assign(current_Y,
            stan::model::rvalue(Y_forecast, "Y_forecast",
              stan::model::index_uni(s)), "assigning variable current_Y");
          current_statement__ = 45;
          if (stan::math::logical_eq(compute_log_lik, 1)) {
            current_statement__ = 43;
            stan::model::assign(log_lik,
              stan::math::multi_normal_cholesky_lpdf<false>(
                stan::model::rvalue(Y_future, "Y_future",
                  stan::model::index_uni(s)), mu, Sigma_chol),
              "assigning variable log_lik", stan::model::index_uni((T + s)));
          }
        }
      }
      out__.write(min_beep);
      out__.write(log_lik);
      out__.write(Sigma_chol);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,-1> Beta_raw =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(K, K, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(Beta_raw,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,-1>>(K, K),
        "assigning variable Beta_raw");
      out__.write(Beta_raw);
      Eigen::Matrix<local_scalar_t__,-1,-1> L_Theta =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(K, K, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(L_Theta,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,-1>>(K, K),
        "assigning variable L_Theta");
      out__.write_free_cholesky_factor_corr(L_Theta);
      Eigen::Matrix<local_scalar_t__,-1,1> sigma_theta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      current_statement__ = 3;
      stan::model::assign(sigma_theta,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(K),
        "assigning variable sigma_theta");
      out__.write(sigma_theta);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "Beta_raw",
        "double",
        std::vector<size_t>{static_cast<size_t>(K), static_cast<size_t>(K)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "L_Theta",
        "double",
        std::vector<size_t>{static_cast<size_t>(K), static_cast<size_t>(K)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "sigma_theta",
        "double", std::vector<size_t>{static_cast<size_t>(K)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,-1> Beta_raw =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(K, K, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> Beta_raw_flat__;
        current_statement__ = 1;
        Beta_raw_flat__ = context__.vals_r("Beta_raw");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 1;
          for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
            current_statement__ = 1;
            stan::model::assign(Beta_raw, Beta_raw_flat__[(pos__ - 1)],
              "assigning variable Beta_raw", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 1;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write(Beta_raw);
      Eigen::Matrix<local_scalar_t__,-1,-1> L_Theta =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(K, K, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> L_Theta_flat__;
        current_statement__ = 2;
        L_Theta_flat__ = context__.vals_r("L_Theta");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
            current_statement__ = 2;
            stan::model::assign(L_Theta, L_Theta_flat__[(pos__ - 1)],
              "assigning variable L_Theta", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 2;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write_free_cholesky_factor_corr(L_Theta);
      Eigen::Matrix<local_scalar_t__,-1,1> sigma_theta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> sigma_theta_flat__;
        current_statement__ = 3;
        sigma_theta_flat__ = context__.vals_r("sigma_theta");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 3;
          stan::model::assign(sigma_theta, sigma_theta_flat__[(pos__ - 1)],
            "assigning variable sigma_theta", stan::model::index_uni(sym1__));
          current_statement__ = 3;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(sigma_theta);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"Beta_raw", "L_Theta", "sigma_theta"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"Beta", "Sigma", "Rho"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"min_beep", "log_lik", "Sigma_chol"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(K),
                                                 static_cast<size_t>(K)},
                std::vector<size_t>{static_cast<size_t>(K),
                  static_cast<size_t>(K)},
                std::vector<size_t>{static_cast<size_t>(K)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(K),
               static_cast<size_t>(K)},
             std::vector<size_t>{static_cast<size_t>(K),
               static_cast<size_t>(K)},
             std::vector<size_t>{static_cast<size_t>(K),
               static_cast<size_t>(K)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{},
             std::vector<size_t>{static_cast<size_t>(log_lik_1dim__)},
             std::vector<size_t>{static_cast<size_t>(K),
               static_cast<size_t>(K)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
        param_names__.emplace_back(std::string() + "Beta_raw" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
        param_names__.emplace_back(std::string() + "L_Theta" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      param_names__.emplace_back(std::string() + "sigma_theta" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          param_names__.emplace_back(std::string() + "Beta" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          param_names__.emplace_back(std::string() + "Sigma" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          param_names__.emplace_back(std::string() + "Rho" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "min_beep");
      for (int sym1__ = 1; sym1__ <= log_lik_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          param_names__.emplace_back(std::string() + "Sigma_chol" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
        param_names__.emplace_back(std::string() + "Beta_raw" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= ((K * (K - 1)) / 2); ++sym1__) {
      param_names__.emplace_back(std::string() + "L_Theta" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      param_names__.emplace_back(std::string() + "sigma_theta" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          param_names__.emplace_back(std::string() + "Beta" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          param_names__.emplace_back(std::string() + "Sigma" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          param_names__.emplace_back(std::string() + "Rho" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "min_beep");
      for (int sym1__ = 1; sym1__ <= log_lik_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          param_names__.emplace_back(std::string() + "Sigma_chol" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"Beta_raw\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(K) + ",\"cols\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"L_Theta\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(K) + ",\"cols\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"sigma_theta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"Beta\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(K) + ",\"cols\":" + std::to_string(K) + "},\"block\":\"transformed_parameters\"},{\"name\":\"Sigma\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(K) + ",\"cols\":" + std::to_string(K) + "},\"block\":\"transformed_parameters\"},{\"name\":\"Rho\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(K) + ",\"cols\":" + std::to_string(K) + "},\"block\":\"transformed_parameters\"},{\"name\":\"min_beep\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(log_lik_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"Sigma_chol\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(K) + ",\"cols\":" + std::to_string(K) + "},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"Beta_raw\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(K) + ",\"cols\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"L_Theta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(((K * (K - 1)) /2)) + "},\"block\":\"parameters\"},{\"name\":\"sigma_theta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"Beta\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(K) + ",\"cols\":" + std::to_string(K) + "},\"block\":\"transformed_parameters\"},{\"name\":\"Sigma\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(K) + ",\"cols\":" + std::to_string(K) + "},\"block\":\"transformed_parameters\"},{\"name\":\"Rho\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(K) + ",\"cols\":" + std::to_string(K) + "},\"block\":\"transformed_parameters\"},{\"name\":\"min_beep\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(log_lik_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"Sigma_chol\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(K) + ",\"cols\":" + std::to_string(K) + "},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((K * K) + (K * K)) + K);
    const size_t num_transformed = emit_transformed_parameters * ((((K * K) +
      (K * K)) + (K * K)));
    const size_t num_gen_quantities = emit_generated_quantities * (((1 +
      log_lik_1dim__) + (K * K)));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((K * K) + (K * K)) + K);
    const size_t num_transformed = emit_transformed_parameters * ((((K * K) +
      (K * K)) + (K * K)));
    const size_t num_gen_quantities = emit_generated_quantities * (((1 +
      log_lik_1dim__) + (K * K)));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_VAR_LKJ_beep_namespace::model_VAR_LKJ_beep;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_VAR_LKJ_beep_namespace::profiles__;
}
#endif
#endif
