#' @keywords internal
#' @importFrom utils combn
composite <- function(scores, M, SD, b, corm) {
  scores_sum = sum(b * scores)
  M_sum = sum(b * M)
  numerator = scores_sum - M_sum
  var_s = sum(b^2 * SD^2)
  var_e = 0
  combs = combn(seq_along(scores), 2, simplify = FALSE)
  combs = do.call(rbind, lapply(combs, function(x) data.frame(v1 = x[1], v2 = x[2])))
  var_e = sum(
    mapply(function(i, j) {
      2 * b[i] * b[j] * corm[i, j] * SD[i] * SD[j]
    }, combs$v1, combs$v2)
  )
  var_t = var_s + var_e
  sd_t = sqrt(var_t)
  combined = numerator / sd_t
  return(combined)
}
