% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cond_cov.R
\name{cond_cov}
\alias{cond_cov}
\title{Modifications of Data and Models for Moderated Mediation}
\usage{
cond_cov (m_model, y_model, data, X, M, cov_val)
}
\arguments{
\item{m_model}{a fitted model object for the mediator.}

\item{y_model}{a fitted model object for the outcome.}

\item{data}{a dataframe used in the analysis.}

\item{X}{a character variable of the exposure's name.}

\item{M}{a character variable of the mediator's name.}

\item{cov_val}{a character variable of the conditions of the covariates. Each string (element) in the character may include ==, <, >, <=, >=, etc.}
}
\value{
This function returns a list of three objects. A conditional dataframe, an updated mediator model and an updated outcome model.
}
\description{
This function modifies the mediator and outcome model and the dataset according
to the conditions of certain covariates specified by the user.
The conditions are constructed by the character parameter \code{cov_val} with multiple string elements.
This function then modifies the data and models based on rules of conditional regressions.
The amount of sample and model structure are changed correspondingly. The samples and model variables satisfy the conditions
are finally remain. Therefore, This function is only involved when moderated mediation effects are considered in the analysis.

This is an internal function, automatically called by the function \code{\link{FormalEstmed}}.
}
