% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_access_utilities.R
\name{remove_by_label}
\alias{remove_by_label}
\title{Remove Teal Modules by Label}
\usage{
remove_by_label(x, label)
}
\arguments{
\item{x}{(\code{teal_module} or \code{teal_modules}) The object to filter.}

\item{label}{(\code{character(1)}) character vector of module labels to remove.}
}
\value{
The filtered teal modules object with matching modules removed, or \code{NULL}
if all modules are removed.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Recursively removes modules from a teal modules structure that match the specified labels.
}
\examples{
mods <- teal::modules(
  teal::example_module("mod1"),
  teal::example_module("mod2")
)
# Remove a single module
filtered_mods <- remove_by_label(mods, "Deaths")

# Remove multiple modules
filtered_mods <- remove_by_label(mods, c("Deaths", "Lab Summary Table"))

}
