% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-info.R
\name{vapour_geolocation}
\alias{vapour_geolocation}
\title{Retrieve geolocation information for a dataset}
\usage{
vapour_geolocation(x, sds = NULL)
}
\arguments{
\item{x}{data source string (i.e. file name or URL or database connection string)}

\item{sds}{a subdataset number, if necessary}
}
\value{
list with a single character vector
}
\description{
Value is a named vector in a list.
}
\details{
If no geolocation exist the return value is an empty list.
}
\examples{
drivers <- vapour_all_drivers()
ok <- drivers$raster[ drivers$driver == "netCDF"]
if (isTRUE(ok) && interactive()) {
 vapour_geolocation(system.file("extdata/gdal/geos_rad.nc", package = "vapour"), 0L)
}
}
