% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_ecis.R
\name{ecis_import}
\alias{ecis_import}
\title{Import all ECIS values, a child of ecis_import_raw and ecis_import_model}
\usage{
ecis_import(raw = NULL, modeled = NULL, experimentname = NULL)
}
\arguments{
\item{raw}{A raw ABP file to import}

\item{modeled}{A modeled APB file for import}

\item{experimentname}{Name of the experiment to be built into the dataset}
}
\value{
A data frame containing all the data APB generated from an experiment
}
\description{
Import all ECIS values, a child of ecis_import_raw and ecis_import_model
}
\examples{

raw = system.file('extdata/instruments/ecis_TimeResample.abp', package = 'vascr')
modeled = system.file('extdata/instruments/ecis_TimeResample_RbA.csv', package = 'vascr')
experimentname = "TEST"

#Then run the import

data = ecis_import(raw ,modeled,experimentname)
#head(data)
}
