% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glob_cr_vis.R
\name{glob_cr_vis}
\alias{glob_cr_vis}
\title{Global Visualization of SHAP Values for Cubist Rules Model}
\usage{
glob_cr_vis(vip_featured, hiv_data, cr_hyperparameters, vip_train, v_train)
}
\arguments{
\item{vip_featured}{The name of the response variable to explain.}

\item{hiv_data}{The training dataset containing predictor variables and the response variable.}

\item{cr_hyperparameters}{A list of hyperparameters for the CR model, including:
\itemize{
\item \code{committees}: The number of committees to consider.
\item \code{neighbors}: The number of neighbors to consider.
}}

\item{vip_train}{The dataset used for training the CR model.}

\item{v_train}{The response variable used for training the CR model.}
}
\value{
A visualization of global feature importance for the CR model.
}
\description{
This function generates a visualization for the global feature importance of
a Cubist Rules (CR) model trained on HIV data with specified
hyperparameters.
}
\examples{
\dontrun{
library(dplyr)
library(rsample)
library(rules)
library(Cubist)
set.seed(123)
hiv_data <- train2
cr_hyperparameters <- list(neighbors = 5, committees = 58)
vip_featured <- c("cd_2022")
vip_features <- c("cd_2019", "vl_2019", "cd_2021", "vl_2021", "vl_2022")
vip_train <- train2 |>
dplyr::select(rsample::all_of(vip_features))
v_train <- train2 |>
dplyr::select(rsample::all_of(vip_featured))
glob_cr_vis(vip_featured, hiv_data, cr_hyperparameters, vip_train, v_train)
}
}
