% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk.R
\name{risk}
\alias{risk}
\title{Compute Risk Measures}
\usage{
risk(
  cf,
  time_horizon = c(1),
  level = c(0.005, 0.01, 0.1, 0.2, 0.5, 0.8, 0.9, 0.99, 0.995),
  discount = 0,
  output = "LR"
)
}
\arguments{
\item{cf}{A data.frame containing simulated cash flow results. Must include columns: \code{split}, \code{sim_n}, \code{PREM}, \code{CLAIM}, \code{DURATION}.}

\item{time_horizon}{A numeric vector specifying time horizons (e.g., c(1, 5, 10)).}

\item{level}{A numeric vector of confidence levels for risk quantification (e.g., c(0.01, 0.1, 0.99)).}

\item{discount}{Annual discount rate to convert future cash flows to present value. Default is 0 (no discount).}

\item{output}{The metric to be analyzed: \code{"LR"} for loss ratio or \code{"BAL"} for balance. Default is \code{"LR"}.}
}
\value{
A data.frame summarizing VaR and TVaR values across the specified horizons and confidence levels.
}
\description{
Computes Value-at-Risk (VaR) and Tail Value-at-Risk (TVaR) based on simulated insurance cash flows.
The function supports discounting for multi-year horizons and can evaluate loss ratio (LR) or balance (BAL).
}
\examples{
# Using example_simulation dataset (assumes data is loaded)
result <- risk(example_simulation,
               time_horizon = c(1, 10),
               level = c(0.01, 0.99),
               discount = 0.02,
               output = "BAL")
print(result)
}
