% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signpost.R
\name{signpost}
\alias{signpost}
\title{A simple, multi-purpose router}
\usage{
signpost()
}
\value{
A \code{waysign} router. See the \emph{Methods} section for a description of
its behavior
}
\description{
The \code{signpost} class implements a high-performance, multipurpose router build
on top of the \href{https://github.com/viz-rs/path-tree}{path-tree} library. A
router associates filepath-like patterns with a piece of data for latter
retrieval. Often that data is a function and the path to be matched against
the pattern comes from a URL, but it can be anything, adapting to the need
of the user. Objects of the class uses reference semantics so they do not get
copied and alterations will affect all instances of the object.
}
\details{
The path pattern supported by Waysign mirrors that of path-tree and while the
full documentation can be found there, it will be briefly explained here.

A path pattern consist of zero, one, or more elements separated by \code{/}
(always started by \code{/}). Each element can either be a literal or one of the
following variable types:
\itemize{
\item \verb{:name} matches a single path piece
\item \verb{:name?} matches an optional path piece
\item \verb{:name+} or \code{+} matches one or more path pieces
\item \verb{:name*} or \code{*} matches zero or more path pieces
}

A variable don't have to consume a full path element. E.g. you could have a
path pattern like this: \verb{/date/:day-:month-:year} which would match to paths
such as \verb{/date/24-12-2025}
}
\section{Methods}{
\subsection{\code{add_path(path, object)}}{

Add a new path to the router. See \emph{Details} for allowed path syntax
\subsection{Arguments}{
\itemize{
\item \code{path}: A string giving the path to add
\item \code{object}: An R object to be associated with the path
}
}

\subsection{Returns}{

The object, invisibly
}

}

\subsection{\code{find_object(path)}}{

Search for a path in the router
\subsection{Arguments}{
\itemize{
\item \code{path}: The path to search for
}
}

\subsection{Returns}{

If no matching path is found then \code{NULL}, otherwise a list with
the elements \code{path} giving the path pattern that was matched, \code{object}
giving the object associated with the path, and \code{params} being a named list
of the path parameters from the match
}

}

\subsection{\code{remove_path(path)}}{

Remove a path from the router. Due to the underlying implementation this
causes a complete rebuild of the router
\subsection{Arguments}{
\itemize{
\item \code{path}: A string giving the path to remove
}
}

\subsection{Returns}{

The object, invisibly
}

}

\subsection{\code{has_path(path)}}{

Check if a given path is present in the router
\subsection{Arguments}{
\itemize{
\item \code{path}: The path pattern to check for
}
}

\subsection{Returns}{

A boolean indicating the existence of \code{path}
}

}

\subsection{\code{paths()}}{

Provides a named list of all the objects, named by their path pattern
}
}

\examples{
# Adapted from path-tree docs
router <- signpost()

router$add_path("/", 1)
router$add_path("/login", 2)
router$add_path("/signup", 3)
router$add_path("/settings", 4)
router$add_path("/settings/:page", 5)
router$add_path("/:user", 6)
router$add_path("/:user/:repo", 7)
router$add_path("/public/:any*", 8)
router$add_path("/:org/:repo/releases/download/:tag/:filename.:ext", 9)
router$add_path("/:org/:repo/tags/:day-:month-:year", 10)
router$add_path("/:org/:repo/actions/:name\\\\::verb", 11)
router$add_path("/:org/:repo/:page", 12)
router$add_path("/:org/:repo/*", 13)
router$add_path("/api/+", 14)

router$find_object("/")
router$find_object("/login")
router$find_object("/settings/admin")
router$find_object("/viz-rs")
router$find_object("/viz-rs/path-tree")
router$find_object("/rust-lang/rust-analyzer/tags/2022-09-12")
router$find_object("/rust-lang/rust-analyzer/actions/ci:bench")
router$find_object("/rust-lang/rust-analyzer/stargazers")
router$find_object("/rust-lang/rust-analyzer/stargazers/404")
router$find_object("/public/js/main.js")
router$find_object("/api/v1")

}
