% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_analysis_filters.R
\name{wbt_line_detection_filter}
\alias{wbt_line_detection_filter}
\title{Line detection filter}
\usage{
wbt_line_detection_filter(
  input,
  output,
  variant = "vertical",
  absvals = FALSE,
  clip = 0,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input}{Input raster file path. See \code{wbt_file_path()} for details.}

\item{output}{Output raster file.}

\item{variant}{Optional variant value. Options include 'v' (vertical), 'h' (horizontal), '45', and '135' (default is 'v').}

\item{absvals}{Optional flag indicating whether outputs should be absolute values.}

\item{clip}{Optional amount to clip the distribution tails by, in percent.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Performs a line-detection filter on an image.
}
\keyword{ImageProcessingToolsFilters}
