% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HAI.R
\name{HAI}
\alias{HAI}
\title{Half-weight Association Index}
\usage{
HAI(traj, traj2, hr = NULL, tc = 0, dc = 50)
}
\arguments{
\item{traj}{an object of the class \code{move2} which contains the time-stamped movement fixes of at least two individuals. For more information on objects of this type see \code{help(mt_as_move2)}.}

\item{traj2}{(optional) same as traj, but for the second group of individuals. See \code{checkTO}}

\item{hr}{(optional)spatial polygon \code{sf} object associated with the home range (or some other form of) spatial range estimate for each individual in \code{traj}. The hr polygon should have a corresponding ID column with the same column name as in \code{traj}. If NULL (the default) the MCP home range estimate will be used for each individual.}

\item{tc}{time threshold for determining simultaneous fixes -- see function: \code{GetSimultaneous}.}

\item{dc}{distance tolerance limit (in appropriate units) for defining when two fixes are spatially together.}
}
\value{
This function returns the numeric value of the HAI statistic. Values near 1 indicate attraction within the shared home range area, while values near 0 indicate avoidance within this shared area.
}
\description{
This function computes the Half-weight Association Index for examining the presence of dynamic interaction in wildlife telemetry studies. This implementation follows that outlined in the paper Atwood and Weeks (2003).
}
\details{
This function can be used to test for the presence of dynamic interaction within the shared area (often termed the overlap zone) of the two animals home ranges. Specifically, HAI is calculated in identical fashion to that for \code{Ca}, but considers only those fixes in the shared area. Typically, the overlap zone (OZ) is easily obtained by taking the spatial intersection of two polygon home ranges.
}
\examples{
\dontrun{
data(deer)

#uses as a default minimum convex polygon for home range...
#tc = 7.5 minutes, dc = 50 meters
HAI(deer, tc=7.5*60, dc=50)
}
}
\references{
Atwood, T.C. and Weeks Jr., H.P. (2003) Spatial home-range overlap and temporal
interaction in eastern coyotes: The influence of pair types and fragmentation.
\emph{Canadian Journal of Zoology}, \bold{81}: 1589-1597.\cr\cr
}
\seealso{
GetSimultaneous, Ca
}
\keyword{indices}
