% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{moon_reader}
\alias{moon_reader}
\alias{tsukuyomi}
\title{An R Markdown output format for remark.js slides}
\usage{
moon_reader(
  css = c("default", "default-fonts"),
  self_contained = FALSE,
  seal = TRUE,
  yolo = FALSE,
  chakra = "https://remarkjs.com/downloads/remark-latest.min.js",
  nature = list(),
  anchor_sections = FALSE,
  ...
)

tsukuyomi(...)
}
\arguments{
\item{css}{A vector of CSS file paths. Two default CSS files
(\file{default.css} and \file{default-fonts.css}) are provided in this
package, which was borrowed from \url{https://remarkjs.com}. If the character
vector \code{css} contains a value that does not end with \code{.css}, it is supposed
to be a built-in CSS file in this package, e.g., for \code{css = c('default', 'extra.css')}), it means \code{default.css} in this package and a user-provided
\code{extra.css}. To find out all built-in CSS files, use
\code{xaringan:::list_css()}. With \pkg{rmarkdown} >= 2.8, Sass files (filenames
ending with \file{.scss} or \file{.sass}) can also be used, and they will
be processed by the \pkg{sass} package, which needs to be installed.}

\item{self_contained}{Whether to produce a self-contained HTML file by
embedding all external resources into the HTML file. See the \sQuote{Note}
section below.}

\item{seal}{Whether to generate a title slide automatically using the YAML
metadata of the R Markdown document (if \code{FALSE}, you should write the title
slide by yourself).}

\item{yolo}{Whether to insert the \href{https://kbroman.wordpress.com/2014/08/28/the-mustache-photo/}{Mustache Karl (TM)}
randomly in the slides. \code{TRUE} means insert his picture on one slide, and
if you want him to be on multiple slides, set \code{yolo} to a positive integer
or a percentage (e.g. 0.3 means 30\\% of your slides will be the Mustache
Karl). Alternatively, \code{yolo} can also be a list of the form \code{list(times = n, img = path)}: \code{n} is the number of times to show an image, and \code{path} is
the path to an image (by default, it is Karl).}

\item{chakra}{A path to the remark.js library (can be either local or
remote). Please note that if you use the default remote latest version of
remark.js, your slides will not work when you do not have Internet access.
They might also be broken after a newer version of remark.js is released.
If these issues concern you, you should download remark.js locally (e.g.,
via \code{\link[=summon_remark]{summon_remark()}}), and use the local version instead.}

\item{nature}{(Nature transformation) A list of configurations to be passed
to \code{remark.create()}, e.g. \code{list(ratio = '16:9', navigation = list(click = TRUE))}; see \url{https://github.com/gnab/remark/wiki/Configuration}. Besides
the options provided by remark.js, you can also set \code{autoplay} to a number
(the number of milliseconds) so the slides will be played every \code{autoplay}
milliseconds; alternatively, \code{autoplay} can be a list of the form
\code{list(interval = N, loop = TRUE)}, so the slides will go to the next page
every \code{N} milliseconds, and optionally go back to the first page to restart
the play when \code{loop = TRUE}. You can also set \code{countdown} to a number (the
number of milliseconds) to include a countdown timer on each slide. If
using \code{autoplay}, you can optionally set \code{countdown} to \code{TRUE} to include a
countdown equal to \code{autoplay}. To alter the set of classes applied to the
title slide, you can optionally set \code{titleSlideClass} to a vector of
classes; the default is \code{c("center", "middle", "inverse")}.}

\item{anchor_sections, ...}{For \code{tsukuyomi()}, arguments passed to
\code{moon_reader()}; for \code{moon_reader()}, arguments passed to
\code{\link[rmarkdown:html_document]{rmarkdown::html_document()}}.}
}
\description{
This output format produces an HTML file that contains the Markdown source
(knitted from R Markdown) and JavaScript code to render slides. \code{tsukuyomi()}
is an alias of \code{moon_reader()}.
}
\details{
Tsukuyomi is a genjutsu to trap the target in an illusion on eye contact.

If you are unfamiliar with CSS, please see the \href{https://github.com/yihui/xaringan/wiki}{xaringan wiki on Github} providing CSS slide
modification examples.
}
\note{
Do not stare at Karl's picture for too long after you turn on the
\code{yolo} mode. I believe he has Sharingan.

For the option \code{self_contained = TRUE}, it encodes images as base64 data in
the HTML output file. The image path should not contain the string \code{")"}
when the image is written with the syntax \verb{![](PATH)} or \code{background-image: url(PATH)}, and should not contain the string \code{"/>"} when it is written
with the syntax \verb{<img src="PATH" />}. Rendering slides in the
self-contained mode can be time-consuming when you have remote resources
(such as images or JS libraries) in your slides because these resources
need to be downloaded first. We strongly recommend that you download
remark.js (via \code{\link[=summon_remark]{summon_remark()}}) and use a local copy instead of the
default \code{chakra} argument when \code{self_contained = TRUE}, so remark.js does
not need to be downloaded each time you compile your slides.

When the slides are previewed via \code{\link[=inf_mr]{inf_mr()}}, \code{self_contained}
will be temporarily changed to \code{FALSE} even if the author of the slides set
it to \code{TRUE}. This will make it faster to preview slides locally (by
avoiding downloading remote resources explicitly and base64 encoding them).
You can always click the Knit button in RStudio or call
\code{rmarkdown::render()} to render the slides in the self-contained mode
(these approaches will respect the \code{self_contained} setting).

Each page has its own countdown timer (when the option \code{countdown} is set
in \code{nature}), and the timer is (re)initialized whenever you navigate to a
new page. If you need a global timer, you can use the presenter's mode
(press \kbd{P}).
}
\examples{
# rmarkdown::render('foo.Rmd', 'xaringan::moon_reader')
}
\references{
\url{https://naruto.fandom.com/wiki/Tsukuyomi}
}
