% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNFhelpers.R
\name{expandRules}
\alias{expandRules}
\title{Replaces rules with fNTs and terminals by a new set of rules with terminals.}
\usage{
expandRules(rPT, SPT, G)
}
\arguments{
\item{rPT}{Rules fNTs and terminals.}

\item{SPT}{Current short production table (SPT).}

\item{G}{The grammar.}
}
\value{
The extended short production table.
}
\description{
Replaces rules with fNTs and terminals by a new set of rules with terminals.
}
\examples{
g<-compileBNF(booleanGrammar())
finiteRules<-finiteRulesOfG(g)
SPT<-newPT(LHS=g$PT$LHS[finiteRules], RHS=g$PT$RHS[finiteRules])
rest<-!(finiteRulesOfG(g) | directRecursion(g))
restPT<-newPT(LHS=g$PT$LHS[rest], RHS=g$PT$RHS[rest])
nSPT<-expandRules(rPT=restPT, SPT=SPT, g)
printPT(nSPT, g)

}
\seealso{
Other Compilation of short production table: 
\code{\link{allTerminal}()},
\code{\link{cL}()},
\code{\link{directRecursion}()},
\code{\link{expandGrid}()},
\code{\link{findNextRuleForExpansion}()},
\code{\link{finiteRulesOfG}()},
\code{\link{nonTerminalsOfG}()},
\code{\link{smallestRules}()}
}
\concept{Compilation of short production table}
