% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNFpreprocessing.R
\name{preBNF}
\alias{preBNF}
\title{BNF preprocessing.}
\usage{
preBNF(BNFfn, genv = NULL)
}
\arguments{
\item{BNFfn}{A constant function which returns a BNF.}

\item{genv}{The list of bindings needed by the macros in the R-code.}
}
\value{
A list with elements \code{filename} and \code{BNF}
}
\description{
The BNF preprocessor executes macros 
             (R-code embedded in a BNF grammar definition) 
             and replaces the macros by the output they produce.
}
\details{
The embedded R-code starts with \code{" //R//"} and ends 
         with "\code{" //R//"}. The preprocessor accepts a binding 
         list which binds R objects their values. The macros are 
         evaluated in an environment with these bindings. 
         The output of each macro is inserted into the grammar file.
         It is expected that after preprocessing, the grammar file 
         is in the BNF-notation. For example, generic grammar files
         can be provided for which the number of symbols of a certain 
         type (e.g. variables) can be specified by the bindings.
}
\examples{
a<-preBNF(booleanGrammar)
b<-preBNF(booleanGrammarK, list(k=5))

}
\seealso{
Other Grammar Preprocessor: 
\code{\link{evenMacro}()},
\code{\link{existsMacro}()},
\code{\link{pastePart}()}
}
\concept{Grammar Preprocessor}
