% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t2df.R
\name{treeToDataFrames}
\alias{treeToDataFrames}
\title{Convert a tree to two dataframes.}
\usage{
treeToDataFrames(tree, G, verbose)
}
\arguments{
\item{tree}{Derivation tree.}

\item{G}{The context-free grammar.}

\item{verbose}{If TRUE, print derivations on console. 
Default: FALSE.}
}
\value{
A named list with two data frames:
        \enumerate{
        \item The data frame \code{$V} of vertices with the columns
              \code{$V$id} (numerical identifier) and \code{$V$name}
              (symbol of the grammar G).
        \item The data frame \code{$E} of edges with the columns 
              \code{$E$from} and \code{$E$to$}.
              }
}
\description{
Converts a derivation tree into a list of two data frames.
             With the R-package \code{igraph} the data frames 
             can be plotted as a derivation tree.
}
\details{
Works with complete and incomplete derivation trees.
}
\examples{
g<-compileBNF(booleanGrammar())
a<-randomDerivationTree(g$Start, g)
x<-treeToDataFrames(a, g, verbose=TRUE)
# library(igraph) 
# g1<-graph_from_data_frame(x$E, directed=TRUE, vertices=x$V)
# plot(g1, layout=layout_as_tree)

}
\concept{Conversion}
