% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgaProblems.R
\docType{data}
\name{Parabola2D}
\alias{Parabola2D}
\title{Problem environment for a 2-dimensional quadratic parabola}
\format{
An object of class \code{list} of length 8.
}
\usage{
Parabola2D
}
\value{
A named list 
     \itemize{
     \item \code{$name()}: Returns the name of the problem environment.
     \item \code{$bitlength()}: The vector of the 
                                bitlengths of the parameters.  
     \item \code{$genelength()}: The number of bits of a gene.  
     \item \code{$lb()}:         The vector of lower bounds 
                                of the parameters. 
     \item \code{$ub()}:  The vector of upper bounds of the parameters. 
     \item \code{$f(parm)}:   The implementation of the function of the
                          quadratic parabola. 
           \itemize{
                   \item \code{parm}:  A 2-element vector of reals.
                   \item Returns the value of the function.
                   }
     \item \code{$describe()}:   Returns the description of 
                         the problem environment.
     \item \code{$solution()}:   The solutions (maxima/minima) of the 
                         problem environment (if known). 
      }
}
\description{
Problem environment for finding maxima and minima
             of a 2-dimensional quadratic parabola.
}
\examples{
names(Parabola2D)
Parabola2D$name()
Parabola2D$describe()
Parabola2D$bitlength()
Parabola2D$genelength()
Parabola2D$lb()
Parabola2D$ub()
Parabola2D$f
Parabola2D$f(c(2.2, -1.37))
Parabola2D$solution()
Parabola2D$solution()$minimum
Parabola2D$solution()$minpoints
Parabola2D$solution()$maximum
Parabola2D$solution()$maxpoints
}
\seealso{
Other Problem Environment: 
\code{\link{NewEnvXOR}()},
\code{\link{Parabola2DEarly}},
\code{\link{lau15}}
}
\concept{Problem Environment}
\keyword{datasets}
