% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tickers.R
\name{get_tickers}
\alias{get_tickers}
\title{Get Ticker Objects}
\usage{
get_tickers(..., proxy = NULL)
}
\arguments{
\item{...}{One or more ticker symbols as separate arguments (e.g., "AAPL", "MSFT")}

\item{proxy}{Optional proxy settings}
}
\value{
For a single symbol: A list containing ticker data and methods with class "yf_ticker"
For multiple symbols: A list containing multiple ticker objects with class "yf_tickers"
}
\description{
Creates one or more ticker objects for accessing data for ticker symbols.
This function handles both single and multiple ticker symbols and validates
the provided ticker symbols.
}
\section{Rate Limiting}{

Yahoo Finance does not provide official API documentation or rate limits. Based on community
observations, there are approximate limits of a few hundred requests per day from a single IP
address before throttling may occur. When working with multiple tickers, consider:
\itemize{
\item Batching requests when possible
\item Adding delays between requests using \code{Sys.sleep()}
\item Caching results for frequently accessed tickers
\item Using the batch functions (e.g., \code{get_tickers_history()}) instead of individual calls
}
}

\examples{
\dontrun{
# Get a single ticker
apple <- get_tickers("AAPL")

# Get historical data for a single ticker
apple_history <- get_history(apple)

# Get company information for a single ticker
apple_info <- get_info(apple)

# Get multiple tickers
tech_tickers <- get_tickers("AAPL", "MSFT", "GOOG")

# Get information for multiple tickers
tech_info <- get_tickers_info(tech_tickers)

# Get historical data for multiple tickers
tech_history <- get_tickers_history(tech_tickers, period = "1y")
}
}
