% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zetadiv.R
\name{Zeta.sam.sensitivity}
\alias{Zeta.sam.sensitivity}
\title{Sensitivity analysis for the sample size of zeta}
\usage{
Zeta.sam.sensitivity(
  data.spec,
  xy = NULL,
  order = 1,
  sam.seq,
  reps = 20,
  sd.correct = TRUE,
  sd.correct.adapt = FALSE,
  rescale = FALSE,
  normalize = FALSE,
  NON = FALSE,
  FPO = NULL,
  DIR = FALSE,
  display = TRUE,
  plot = TRUE,
  notch = TRUE
)
}
\arguments{
\item{data.spec}{Site-by-species presence-absence data frame, with sites as rows and species as columns.}

\item{xy}{Site coordinates. This is only used if \code{NON} = TRUE or \code{DIR} = TRUE.}

\item{order}{Specific number of assemblages or sites at which zeta diversity is computed.}

\item{sam.seq}{Sequence of samples for which the zeta diversity is computed.}

\item{reps}{Number of replicates of zeta diversity computations for each sample size.}

\item{sd.correct}{Boolean value (TRUE or FALSE) indicating if the standard deviation must be computed with an unbiased estimator (using the number of site combinations - 1 as the denominator) or not (using the number of site combinations as the denominator).}

\item{sd.correct.adapt}{Boolean value (TRUE or FALSE) indicating if the standard deviation must be computed with an unbiased estimator (using the number of site combinations - 1 as the denominator) if \code{sam} is higher than the number of possible combinations, or not (using the number of site combinations as the denominator) if \code{sam} is lower than the number of possible combinations. If \code{sd.correct.adapt == TRUE}, it takes precedence over \code{sd.correct}.}

\item{rescale}{Boolean value (TRUE or FALSE) indicating if the zeta values should be divided by \eqn{\zeta_1}, to get a range of values between 0 and 1.}

\item{normalize}{Indicates if the zeta values for each sample should be divided by the total number of species for this specific sample (\code{normalize = "Jaccard"}), by the average number of species per site for this specific sample (\code{normalize = "Sorensen"}), or by the minimum number of species in the sites of this specific sample \cr (\code{normalize = "Simpson"}). Default value is \code{FALSE}, indicating that no normalization is performed.}

\item{NON}{Boolean value (TRUE or FALSE) indicating if the number of species in common should only be counted for the nearest neighbours.}

\item{FPO}{A vector with the coordinates of the fixed point origin from which the zeta diversity will be computed (overrides NON). In that case, \eqn{\zeta_1} is the number of species in the closest site to the FPO, \eqn{\zeta_2} is the number of species shared by the 2 closest sites, etc.}

\item{DIR}{Boolean value (TRUE or FALSE) indicating if zeta diversity must be computed using a directed nearest neighbour scheme in the direction away from the FPO, starting from any site.}

\item{display}{Boolean value (TRUE or FALSE) indicating if the current value of the sample size must be displayed. Acts as a counter.}

\item{plot}{Boolean value (TRUE or FALSE) indicating if the outputs must be plotted as a boxplot of the zeta diversity distributions for each sample size}

\item{notch}{Boolean value (TRUE or FALSE) indicating if the notches must be plotted in the boxplot.}
}
\value{
\code{Zeta.sam.sensitivity} returns a matrix with \code{(sam.max-sam.min)/sam.incr} columns and \code{reps} rows.
}
\description{
Computes zeta diversity for a given order (number of assemblages or sites) for a range of sample sizes, to assess the sensitivity to this parameter.
}
\details{
Note that the execution of \code{Zeta.sam.sensitivity} can be quite lengthy, because of the number of replicates needed.
}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.
}
\seealso{
\code{\link{Zeta.decline.mc}}, \code{\link{Zeta.order.mc}}, \code{\link{Zeta.decline.ex}}, \code{\link{Zeta.order.ex}}
}
